% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{max_cardinality}
\alias{max_cardinality}
\title{Maximum cardinality search}
\usage{
max_cardinality(graph)
}
\arguments{
\item{graph}{The input graph. It may be directed, but edge directions are
ignored, as the algorithm is defined for undirected graphs.}
}
\value{
A list with two components: \item{alpha}{Numeric vector. The
1-based rank of each vertex in the graph such that the vertex with rank 1
is visited first, the vertex with rank 2 is visited second and so on.}
\item{alpham1}{Numeric vector. The inverse of \code{alpha}. In other words,
the elements of this vector are the vertices in reverse maximum cardinality
search order.}
}
\description{
Maximum cardinality search is a simple ordering a vertices that is useful in
determining the chordality of a graph.
}
\details{
Maximum cardinality search visits the vertices in such an order that every
time the vertex with the most already visited neighbors is visited. Ties are
broken randomly.

The algorithm provides a simple basis for deciding whether a graph is
chordal, see References below, and also \code{\link[=is_chordal]{is_chordal()}}.
}
\examples{

## The examples from the Tarjan-Yannakakis paper
g1 <- graph_from_literal(
  A - B:C:I, B - A:C:D, C - A:B:E:H, D - B:E:F,
  E - C:D:F:H, F - D:E:G, G - F:H, H - C:E:G:I,
  I - A:H
)
max_cardinality(g1)
is_chordal(g1, fillin = TRUE)

g2 <- graph_from_literal(
  A - B:E, B - A:E:F:D, C - E:D:G, D - B:F:E:C:G,
  E - A:B:C:D:F, F - B:D:E, G - C:D:H:I, H - G:I:J,
  I - G:H:J, J - H:I
)
max_cardinality(g2)
is_chordal(g2, fillin = TRUE)
}
\references{
Robert E Tarjan and Mihalis Yannakakis. (1984). Simple
linear-time algorithms to test chordality of graphs, test acyclicity of
hypergraphs, and selectively reduce acyclic hypergraphs.  \emph{SIAM Journal
of Computation} 13, 566--579.
}
\seealso{
\code{\link[=is_chordal]{is_chordal()}}

Other chordal: 
\code{\link{is_chordal}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{chordal}
\keyword{graphs}
