% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-and-data.R
\docType{data}
\name{dot-data}
\alias{dot-data}
\alias{.data}
\alias{dot-env}
\alias{.env}
\title{\code{.data} and \code{.env} pronouns}
\description{
The \code{.data} and \code{.env} pronouns make it explicit where to look up attribute
names when indexing \code{V(g)} or \code{E(g)}, i.e. the vertex or edge sequence of a
graph. These pronouns are inspired by \code{.data} and \code{.env} in \code{rlang} - thanks
to Michał Bojanowski for bringing these to our attention.

The rules are simple:
\itemize{
\item \code{.data} retrieves attributes from the graph whose vertex or edge sequence
is being evaluated.
\item \code{.env} retrieves variables from the calling environment.
}

Note that \code{.data} and \code{.env} are injected dynamically into the environment
where the indexing expressions are evaluated; you cannot get access to these
objects outside the context of an indexing expression. To avoid warnings
printed by \verb{R CMD check} when code containing \code{.data} and \code{.env} is checked,
you can import \code{.data} and \code{.env} from \code{igraph} if needed. Alternatively,
you can declare them explicitly with \code{utils::globalVariables()} to silence
the warnings.
}
\keyword{datasets}
