% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_leiden}
\alias{cluster_leiden}
\title{Finding community structure of a graph using the Leiden algorithm of Traag,
van Eck & Waltman.}
\usage{
cluster_leiden(
  graph,
  objective_function = c("CPM", "modularity"),
  weights = NULL,
  resolution_parameter = 1,
  beta = 0.01,
  initial_membership = NULL,
  n_iterations = 2,
  vertex_weights = NULL
)
}
\arguments{
\item{graph}{The input graph, only undirected graphs are supported.}

\item{objective_function}{Whether to use the Constant Potts Model (CPM) or
modularity. Must be either \code{"CPM"} or \code{"modularity"}.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. A larger
edge weight means a stronger connection for this function.}

\item{resolution_parameter}{The resolution parameter to use. Higher
resolutions lead to more smaller communities, while lower resolutions lead
to fewer larger communities.}

\item{beta}{Parameter affecting the randomness in the Leiden algorithm.
This affects only the refinement step of the algorithm.}

\item{initial_membership}{If provided, the Leiden algorithm
will try to improve this provided membership. If no argument is
provided, the aglorithm simply starts from the singleton partition.}

\item{n_iterations}{the number of iterations to iterate the Leiden
algorithm. Each iteration may improve the partition further.}

\item{vertex_weights}{the vertex weights used in the Leiden algorithm.
If this is not provided, it will be automatically determined on the
basis of whether you want to use CPM or modularity. If you do provide
this, please make sure that you understand what you are doing.}
}
\value{
\code{cluster_leiden} returns a \code{\link{communities}}
object, please see the \code{\link{communities}} manual page for details.
}
\description{
Finding community structure of a graph using the Leiden algorithm of Traag,
van Eck & Waltman.
}
\examples{
g <- graph.famous("Zachary")
# By default CPM is used
g <- cluster_leiden(g, resolution_parameter=0.06)

}
\references{
Traag, V. A., Waltman, L., & van Eck, N. J. (2019). From Louvain
  to Leiden: guaranteeing well-connected communities. Scientific
  reports, 9(1), 5233. doi: 10.1038/s41598-019-41695-z
}
\seealso{
See \code{\link{communities}} for extracting the membership,
modularity scores, etc. from the results.

Other community detection algorithms: \code{\link{cluster_walktrap}},
\code{\link{cluster_spinglass}},
\code{\link{cluster_leading_eigen}},
\code{\link{cluster_edge_betweenness}},
\code{\link{cluster_fast_greedy}},
\code{\link{cluster_label_prop}}
\code{\link{cluster_louvain}}
}
\author{
Vincent Traag
}
\keyword{graphs}
