% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosd.R
\encoding{UTF-8}
\name{sec}
\alias{sec}
\title{Secant (in radians)}
\usage{
sec(x)
}
\arguments{
\item{x}{A numeric or complex vector containing values in radians}
}
\value{
The secant of each element of \code{x} in radians.
}
\description{
Calculates the value of secant for each element of \code{x} in radians.
}
\note{
Note: If you have a degree angle value, use \code{\link{secd}} instead.
}
\examples{

library("iemisc")

# Examples

sec (seq(-2, 2, by = 1) * pi)

sec ((3 * pi) / 4)

sec (c((7/3) * pi, (5/2) * pi))


}
\author{
Irucka Embry
}
