% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\encoding{UTF-8}
\name{lengths}
\alias{lengths}
\title{Length of R objects (GNU Octave/MATLAB compatible)}
\usage{
lengths(x)
}
\arguments{
\item{x}{An R object (array, matrix, vector)}
}
\value{
Return the length of the object x as an integer. "The length is 0
  for empty objects, 1 for scalars (in R, a \code{vector} of \code{length} 1), and
  the number of elements (in R, the \code{length}) for vectors. For matrix objects,
  the length is the number of rows or columns, whichever is greater (this
  odd definition is used for compatibility with MATLAB)." Source: Eaton.
}
\description{
Obtain the length of R objects [arrays, matrices, and vectors (including
lists)] in a manner compatible with GNU Octave/MATLAB. Some documentation
from \code{\link[base]{length}}.
}
\examples{
library(iemisc)
library(import)
import::from(pracma, ones)
# Example from pracma isempty
object1 <- matrix(0, 1, 0)
lengths(object1)

object2 <- 2
lengths(object2)

object3 <- 1:10
lengths(object3)

object4 <- ones(3, 4)
lengths(object4)

object5 <- "ss"
lengths(object5)

object6 <- list(letters, b <- 2)
lengths(object6)


\dontrun{
# check against GNU Octave
library(RcppOctave) # requires Octave (>= 3.2.4) and its development files
o_source(text = "
object1 = [];
length(object1)

object2 = 2;
length(object2)

object3 = 1:10;
length(object3)

object4 = ones(3, 4);
length(object4)

object5 = 'ss';
length(object5)
")
}


}
\author{
Irucka Embry, Samit Basu (FreeMat)
}
\references{
\enumerate{
   \item Samit Basu (2002-2006). FreeMat v4.0, \url{http://freemat.sourceforge.net/}.
   \item John W. Eaton, David Bateman, and Søren Hauberg (2009). \emph{GNU Octave version 3.0.1 manual: a high-level interactive language for numerical computations}. CreateSpace Independent Publishing Platform. ISBN 1441413006, URL \url{http://www.gnu.org/software/octave/doc/interpreter/}. Page 41.
}
}
\seealso{
\code{\link[base]{length}}, \code{\link[pracma]{size}}, \code{\link{size}}
}

