% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posCalc.R
\name{posCalc}
\alias{posCalc}
\alias{fillMarkInfo}
\alias{fillMarkInfo2}
\title{FUNCTION posCalc and fillMarkInfo}
\usage{
posCalc(
  dfMarkPos,
  listOfdfChromSize,
  bToRemove = "",
  markDistType = "beg",
  origin = "b",
  showBandList = FALSE,
  result = "tibble"
)

fillMarkInfo2(dfMarkPos, dfChrSize)

fillMarkInfo(dfMarkPos, dfChrSize, markDistType = "beg", origin = "b")
}
\arguments{
\item{dfMarkPos}{data.frame of marks' position}

\item{listOfdfChromSize}{list (for \code{posCalc}) or data.frames of chr. sizes.}

\item{bToRemove, }{character, bands to remove from calc. of pos.}

\item{markDistType}{markDistType character, if \code{"cen"} = the distance you provided in data.frame (\code{dfMarkPos}) column \code{markDistCen}
or \code{markPos}  is to the center of the mark, if \code{"beg"} = the distance you provided is to the
beginning of the mark (Default)}

\item{origin, }{character, For non-monocentric chr. (for holocentrics only) Use \code{"b"} (default) if distance to mark in (\code{"markPos"} column in \code{"dfMarkPos"}) data.frame measured from bottom of chromosome, use \code{"t"} for distance to mark from top of chr.}

\item{showBandList, }{boolean, show row of all bands in tibble, see \code{"result"}}

\item{result}{character, use \code{"tibble"} to get results in tibble, \code{"data.frame"}, or other string results in a \code{list}}

\item{dfChrSize}{data.frame of chr. sizes}
}
\value{
list, tibble

data.frame of marks

data.frame of marks
}
\description{
calculates position of marks in fraction of (\%) chromosome units (0-1)
}
\examples{
load(system.file("shinyApps", "iBoard/www/rda/monoholoCS.rda", package = "idiogramFISH") )
load(system.file("shinyApps", "iBoard/www/rda/monoholoMarks.rda", package = "idiogramFISH") )
monoholoMarks2 <- fillMarkInfo(monoholoMarks,monoholoCS)
posCalc(monoholoMarks2,monoholoCS, result="data.frame")

}
\keyword{chromosome}
\keyword{fraction}
\keyword{mark}
\keyword{position}
