% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIdiogramsHolo.R
\name{plotIdiogramsHolo}
\alias{plotIdiogramsHolo}
\title{Function to plot idiograms without centromere}
\usage{
plotIdiogramsHolo(dfChrSize, dfMarkPos, dfMarkColor, mycolors,
  MarkDistanceType = "beg", origin = "b", orderBySize = TRUE,
  Mb = FALSE, ylabline = 0, chrWidth = 1.5, chrSpacing = 1.5,
  chrColor = "gray", roundness = 4, dotRoundCorr = 1.5,
  karHeight = 1.2, karSpacing = 1.6, reduDistKar = TRUE,
  reduDistKarTol = 9, chrId = "original", distTextChr = 0.3,
  indexIdTextSize = 0.4, OTUTextSize = 0.6, legend = "inline",
  markLabelSize = 0.4, markLabelSpacer = 2, lwd.chr = 1,
  karIndex = TRUE, karIndexPos = 0.5, addOTUName = TRUE,
  revOTUs = FALSE, ruler = TRUE, rulerPos = -0.5, rulerPosMod = 0,
  ruler.tck = -0.004, rulerNumberPos = 0.2, rulerNumberSize = 0.4,
  xlimLeftMod = 1, xlimRightMod = 10, ylimBotMod = 0.2,
  ylimTopMod = 0.2, addMissingOTUAfter = NA, missOTUspacings = 0,
  legendWidth = 1.75, ...)
}
\arguments{
\item{dfChrSize}{dataframe with columns: OTU (optional), chrName, chrSize
(see Mb)}

\item{dfMarkPos}{dataframe of marks (sites): cols: OTU (opt) chrName,
markName (name of site), markPos, markSize}

\item{dfMarkColor}{dataframe specifying colors for marks (sites); cols:
markName, markColor, style: square or dots}

\item{mycolors}{character vector, optional, i.e. \code{c("blue","red","green")} for specifying color of marks in order of appearance. if diverges with number of marks will be recycled if \code{dfMarkColor} present, mycolors will be ignored. To know the
order of your marks use something like: \code{unique(dfMarkPos$markName)}}

\item{MarkDistanceType}{character, if cen = the distance you provided is to
the center of the mark, if beg = the distance you provided is to the
beginning of the mark}

\item{origin}{use "b" if distance to mark (markPos col. in dfMarkPos)
measured from bottom, use "t" for distance to mark from top}

\item{orderBySize}{logical value, when TRUE, sorts chromosomes by total
length from the largest to the smallest}

\item{Mb}{boolean, if TRUE distance in dfs is not micrometers but bases, will be shown as Megabases}

\item{ylabline, }{numeric if \code{Mb=TRUE} modify position of y axis title (Mb)}

\item{chrWidth}{numeric, chromosome width}

\item{chrSpacing}{numeric, horizontal spacing among chromosomes}

\item{chrColor}{character, main color for chromosomes}

\item{roundness}{numeric, shape of vertices of chromosomes and square marks,
higher values more squared}

\item{dotRoundCorr}{numeric, correct roundness of dots and vertices of chromosomes. When style of sites =
dots, an increase in this, makes the horizontal radius of the dot smaller}

\item{karHeight}{numeric, vertical size of karyotypes}

\item{karSpacing}{numeric, proportional to karHeight for spacing of
karyotypes, y axis, if overlap, increase}

\item{reduDistKar}{boolean, reduce distance among karyotypes FALSE = equally
sized karyotypes or TRUE= equally spaced karyotypes}

\item{reduDistKarTol}{numeric, depends on reduDistKar=TRUE, if zero your
karyotypes will have no distance among them, use 1 to 11, if overlap,
increase this and karSpacing}

\item{chrId}{character, print name of chromosme, "original" uses the original
name in OTU column of dfChrSize, "simple" (just 1 to ...) or "" (none).}

\item{distTextChr}{numeric, distance from name of chromosome to chromosome}

\item{indexIdTextSize}{numeric, font size of chromosome name and A2 index}

\item{OTUTextSize}{numeric, font size of OTU name (species)}

\item{legend}{character, "" for no legend; "inline" prints labels near
chromosomes; "aside" prints legend to the right of karyotypes}

\item{markLabelSize}{numeric, only if legend !="", size of the text of labels
of marks (legend)}

\item{markLabelSpacer}{numeric, only if legend !="", space from the rightmost
chr. to legend}

\item{lwd.chr}{numeric, thick of border of chr. or marks}

\item{karIndex}{logical, add karyotype index A2 (interchromosomal asymmetry,
variation among chromosome sizes)}

\item{karIndexPos}{numeric, move karyotype index}

\item{addOTUName}{boolean, if TRUE adds OTU (species) name to karyotype}

\item{revOTUs}{boolean, The order of species is the one in the main
dataframe, use TRUE to reverse}

\item{ruler}{boolean, display ruler to the left of karyotype, when FALSE no ruler}

\item{rulerPos}{numeric, absolute position of ruler, corresponds to pos
argument of axis R plot}

\item{rulerPosMod}{numeric, modify position of ruler, corresponds to line
argument of axis R plot}

\item{ruler.tck}{numeric, tick size of ruler, corresponds to tck argument of
axis R plot}

\item{rulerNumberPos}{numeric, modify position of numbers of ruler}

\item{rulerNumberSize}{numeric, size of number's font in ruler}

\item{xlimLeftMod}{numeric, modifies xlim left parameter of plot}

\item{xlimRightMod}{numeric, xlim modification by adding space to the right
of idiograms}

\item{ylimBotMod}{numeric, modify ylim bottom parameter of plot}

\item{ylimTopMod}{numeric, modify ylim top parameter of plot}

\item{addMissingOTUAfter}{character, when you want to add space (ghost OTUs) after one or several OTUs, pass the names of OTUs preceding the desired space in a vector i.e. \code{c("species one","species five")}}

\item{missOTUspacings}{numeric, when you use addMissingOTUAfter this numeric vector should have the same length and corresponds to the number of free spaces (ghost OTUs) to add after each OTU respectively}

\item{legendWidth}{factor to increase width of squares and boxes of legend}

\item{...}{accepts other arguments for the plot, such as, asp}
}
\value{
plot
}
\description{
This function reads a dataframe  with columns: \code{chrName}
and \code{chrSize} and plots as idiograms. If more than one species, a column
named \code{OTU} is needed. Accepts micrometers and Mb.

Optionally, it reads another dataframe with the position of
marks (sites) \code{dfMarkPos}, in that case the description of marks is
necessary in dataframe \code{dfMarkColor}
}
\examples{
data(dfChrSizeHolo)
plotIdiogramsHolo(dfChrSizeHolo)

}
\seealso{
plotIdiograms

\code{\link{plotIdiograms}}

\code{\link{asymmetryA2}}

\code{\link{chrbasicdataHolo}}

\code{\link{markdataholo}}

\code{\link{dfMarkColor}}
}
\keyword{chromosome}
\keyword{dataframe}
