% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_mice.R
\name{imImpAll_mice}
\alias{imImpAll_mice}
\title{Impute missing data by mice}
\usage{
imImpAll_mice(
  im.data,
  deltas = 0,
  n.imp = 5,
  endponly = TRUE,
  seed = NULL,
  ...
)
}
\arguments{
\item{im.data}{A class \code{IDEMDATA} object generated by \code{\link{imData}}}

\item{deltas}{Vector of imputation sensitivity parameters}

\item{n.imp}{Number of complete datasets required}

\item{endponly}{Logical variable that indicates whether clinical outcomes not
used in calculating the functional outcome are considered as missing and
should be imputed. The default is \code{FALSE}, indicating that all
missing clinical outcomes will be imputed sequentially}

\item{seed}{Random seed}

\item{...}{Parameters for \code{mice}}
}
\value{
A class \code{IDEMIMP} list with components \describe{ \item{lst.var}{List of
parameters} \item{complete}{A dataset with the original data for the subset
of subjects who died at the end of the study or had no missing outcomes and
the \code{n.imp} imputed missing outcomes for subjects who need missing value
imputation. } \item{n.imp}{Number of imputed complete datasets}
\item{deltas}{Imputation sensitivity parameters} \item{org.data}{Original
dataset} }
}
\description{
Conduct imputation using the NARFCS model implemented in the \code{mice}
package
}
\examples{

\dontrun{
rst.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
rst.imp <- imImpAll_mice(rst.abc, deltas=c(-0.25,0,0.25));}

}
