% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{imFitModel}
\alias{imFitModel}
\title{Imputation model fitting}
\usage{
imFitModel(im.data)
}
\arguments{
\item{im.data}{A class \code{IDEMDATA} object generated by \code{\link{imData}}}
}
\value{
A class \code{IDEMFIT} list of modeling fitting results with the following items
\describe{
\item{im.data}{Original class \code{IDEMDATA} object}
\item{rst.mdl}{A list of modeling fitting results for each model with
    \describe{
      \item{lm}{results from function \code{lm}}
      \item{formula}{model formula}
      \item{coef}{model coefficients}
      \item{res}{residuals}
      \item{h}{bandwidth of residuals for kernel density estimation}}
}}
}
\description{
Fit linear imputation models to the observed data from complete survivors for
each treatment arm at each time point
}
\examples{
im.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
im.fit <- imFitModel(im.abc);

}
\seealso{
\code{\link{imData}}, \code{\link{idem-package}}
}
