% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_visualize.R
\name{imPlotContour}
\alias{imPlotContour}
\title{Contour plot of the sensitivity analysis results}
\usage{
imPlotContour(test.rst, con.v = 0.05, nlevels = 30, ...)
}
\arguments{
\item{test.rst}{A class \code{IDEM.TEST} list generated by
\code{\link{imTest}}}

\item{con.v}{Levels of contour plot}

\item{nlevels}{Levels of color scale}

\item{...}{Options for \code{filled.contour}}
}
\description{
Generate contour plot of p-values for sensitivity analysis results
}
\examples{

\dontrun{
lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- imFitModel(abc, lst.var);
rst.imp <- imImpAll(abc, rst.fit, deltas=c(-0.25,0,0.25),
                    normal=TRUE, chains = 4, iter = 2000, warmup = 1000);
rst.final <- imTest(rst.boot);
rst.boot  <- imBs(rst.imp, n.boot = 10, n.cores = 5);
imPlotContour(rst.final, con.v=0.05, nlevels = 30);}

}
