% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qap_setup.R
\name{qap_setup}
\alias{qap_setup}
\title{Individual to Dyadic variable transformation (\code{qap_setup}).}
\usage{
qap_setup(
  net,
  variables = NULL,
  methods = NULL,
  directed = FALSE,
  additional_vars = NULL
)
}
\arguments{
\item{net}{An \code{igraph} or \code{network} object.}

\item{variables}{A vector of strings naming attributes to be transformed from individual-level to dyadic-level.}

\item{methods}{A vector of strings naming methods to be applied to the \code{variables} vector. The \code{methods} vector must be the same length as the \code{variables} vector. Methods are applied in order (e.g, first method is applied to the first named attribute in \code{variables}). Possible methods are "reduced_category", "multi_category", "both", and "difference". For more information about methods, consult the included vignette.}

\item{directed}{A logical statement identifying if the network should be treated as directed. Defaults to \code{FALSE}.}

\item{additional_vars}{A data frame containing additional individual-level variables not contained in the primary network input. Additional dataframe must contain an \code{id} or \code{label} variables which matches network exactly.}
}
\value{
\code{qap_setup} returns a list of elements that include:

- \code{graph}, an updated \code{igraph} object containing the newly constructed dyadic variables and additional individual-level variables.

- \code{nodes}, a nodelist reflecting additional variables if included.

- \code{edges}, a nodelist reflecting new dyadic variables.
}
\description{
The \code{qap_setup} function transform an individual level attributes into dyadic comparisons following a set of methods. Output can be used to compute QAP measurements using sister functions in \code{ideanet}.
}
\examples{


flor <- netwrite(nodelist = florentine_nodes,
                 node_id = "id",
                 i_elements = florentine_edges$source,
                 j_elements = florentine_edges$target,
                 type = florentine_edges$type,
                 directed = FALSE,
                 net_name = "florentine_graph")

flor_setup <- qap_setup(flor$florentine_graph,
                        variables = c("total_degree"),
                        methods = c("difference"))
}
