% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ngq_egos}
\alias{ngq_egos}
\title{Ego Networks Elicited from the "Important Matters" Name Generator Question (Nodelist)}
\format{
A data frame with 20 rows and 9 columns:
\describe{
  \item{ego_id}{Unique identifier for ego providing network}
  \item{age}{A numeric indicating ego's self-reported age}
  \item{sex}{A numeric indicating ego's self-reported sex. \code{1} indicates male, \code{2} female.}
  \item{race}{A character indicating a simplification of ego's self-reported race/ethnicity. Values include \code{"White"}, \code{"Black"}, and \code{"Other"}.}
  \item{black}{A logical indicating ego's self-identification as "Black" or "African-American."}
  \item{white}{A logical indicating ego's self-identification as "White."}
  \item{other_race}{A logical indicating ego's self-identification with a race or ethnicity other than "Black," "African-American," or "White."}
  \item{edu}{A numeric indicating ego's highest level of educational attainment. \code{1} indicates less than a high school diploma, \code{4} indicates a high school diploma or GED, \code{5} some college, \code{6} a college degree, and \code{7} a graduate or professional degree.}
  \item{pol}{A numeric indicating ego's self-identified political orientation on a seven-point scale. \code{1} indicates "Extremely Liberal," \code{4} "Moderate," and \code{7} "Extremely Conservative."}
  ...
}
}
\source{
Original Data, Collected by Danielle Montagne, Joseph Quinn, Liann Tucker, and Tom Wolff.
}
\usage{
ngq_egos
}
\description{
This dataset contains a simplified subset of 20 ego networks elicited using the "important matters" name generator question (NGQ),
which is frequently used to capture an individual's close personal ties. These networks were collected as part
of an experiment illustrating how networks generated by this question may vary depending on the topics covered in
preceding survey items. Networks were collected using an online survey deployed via Amazon Mechanical Turk.
}
\keyword{datasets}
