% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_trans_intervals.R
\name{get_trans_intervals}
\alias{get_trans_intervals}
\title{Get transition intervals from specified data}
\usage{
get_trans_intervals(gd, tmat)
}
\arguments{
\item{gd}{A \code{data.frame} with the following named columns
\describe{
  \item{\code{id}:}{Subject idenitifier;}
  \item{\code{state}:}{State at which the subject is observed at \code{time};}
  \item{\code{time}:}{Time at which the subject is observed;}
} The true transition time between states is then interval censored between the times.}

\item{tmat}{A transition matrix as created by \code{transMat}}
}
\value{
A \code{data.frame} with the following named columns
\describe{
  \item{\code{entry_time}:}{Time of entry into "from" state;}
  \item{\code{time_from}:}{Last time subject(id) was seen in state "from";}
  \item{\code{time_to}:}{First time subject(id) was seen in state "to";}
  \item{\code{from}:}{State from which a transition was observed;}
  \item{\code{to}:}{State to which the transition was observed;}
  \item{\code{id}:}{Subject identifier;}
} For right-censored observations, entry_time denotes the first time
seen in the censored state, time_from the last time seen in the censored state,
time_to is \code{Inf}, from the censored state and to is \code{NA}.
}
\description{
Given a sample from a multi-state model, summarize the transitions 
that have been observed.
}
