% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.bib.R
\name{process.bib}
\alias{process.bib}
\title{Process Metadata}
\usage{
process.bib(bibfile, clean = TRUE, quiet = FALSE)
}
\arguments{
\item{bibfile}{metadata file to process, either \code{"SOFTWARE.bib"} or
\code{"DATA.bib"}.}

\item{clean}{whether to \code{\link{clean}} directories.}

\item{quiet}{whether to suppress messages reporting progress.}
}
\value{
\code{TRUE} for success.
}
\description{
Read and process metadata entries in a \verb{*.bib} file.
}
\details{
If \code{bibfile = "SOFTWARE.bib"} and \code{clean = TRUE}, then
\file{bootstrap/software} is cleaned with \code{\link{clean.software}} and
\file{bootstrap/library} is cleaned with \code{\link{clean.library}} before
processing metadata entries.

If \code{bibfile = "DATA.bib"} and \code{clean = TRUE}, then the
\file{bootstrap/data} directory is cleaned before processing metadata
entries.
}
\note{
This is a helper function for \code{\link{taf.bootstrap}}. It is called
within the \file{bootstrap} directory that contains the metadata file.

For a detailed description of the metadata entry format, see the
\href{https://github.com/ices-taf/doc/wiki/Bib-entries}{TAF Wiki}.
}
\examples{
\dontrun{
process.bib("DATA.bib")
process.bib("SOFTWARE.bib")
}

}
\seealso{
\code{\link{taf.bootstrap}} calls \code{process.bib} to process metadata.

\code{\link{draft.data}} and \code{\link{draft.software}} can be used to
create initial draft versions of \file{DATA.bib} and \file{SOFTWARE.bib}
metadata files.

\code{\link{icesTAF-package}} gives an overview of the package.
}
