% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf2long.R
\name{taf2long}
\alias{taf2long}
\title{Convert TAF Table to Long Format}
\usage{
taf2long(x, names = c("Year", "Age", "Value"))
}
\arguments{
\item{x}{a data frame in TAF format.}

\item{names}{a vector of three column names for the resulting data frame.}
}
\value{
A data frame with three columns.
}
\description{
Convert a table from TAF format to long format.
}
\note{
TAF stores tables as data frames, usually with a year column as seen in stock
assessment reports. The long format is more convenient for analysis and
producing plots.
}
\examples{
taf2long(catage.taf, names=c("Year","Age","Catch"))

}
\seealso{
\code{\link{catage.long}} and \code{\link{catage.taf}} describe the long and
TAF formats.

\code{\link{long2taf}} converts a long table to TAF format.

\code{\link{icesTAF-package}} gives an overview of the package.
}
