% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findAssessmentKey.R
\name{findAssessmentKey}
\alias{findAssessmentKey}
\title{Find a Key}
\usage{
findAssessmentKey(
  stock = NULL,
  year = 0,
  published = TRUE,
  regex = TRUE,
  full = FALSE
)
}
\arguments{
\item{stock}{a stock name, e.g. cod-347d, or cod to find all cod stocks, or NULL (default)
to process all stocks.}

\item{year}{the assessment year, e.g. 2015, or 0 to process all years.}

\item{published}{whether to include only years where status is "Published" (applies only
when non-secure web services are in use, secure web service always
returns unpublished stocks).}

\item{regex}{whether to match the stock name as a regular expression.}

\item{full}{whether to return a data frame with all stock list columns.}
}
\value{
A vector of keys (default) or a data frame if full is TRUE.
}
\description{
Find a lookup key corresponding to a stock in a given assessment year.
}
\examples{
\dontrun{
findAssessmentKey("had.27.46a20", 2023, full = TRUE)
}
}
\seealso{
\code{\link{getListStocks}} gets a list of stocks.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Arni Magnusson and Colin Millar.
}
