% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCAdata.R
\name{getCAdata}
\alias{getCAdata}
\title{Get Age-Based Data}
\usage{
getCAdata(survey, year, quarter)
}
\arguments{
\item{survey}{the survey acronym, e.g. NS-IBTS.}

\item{year}{the year of the survey, e.g. 2010.}

\item{quarter}{the quarter of the year the survey took place, i.e. 1, 2, 3 or 4.}
}
\value{
A data frame.
}
\description{
Get age-based data such as sex, maturity, and age counts per length of sampled species.
}
\examples{
\dontrun{
cadata <- getCAdata(survey = "ROCKALL", year = 2002, quarter = 3)
str(cadata)
}
}
\seealso{
\code{\link{getDATRAS}} supports querying many years and quarters in one function call.

\code{\link{getHHdata}} and \code{\link{getHLdata}} get haul data and
length-based data.

\code{\link{icesDatras-package}} gives an overview of the package.
}
\author{
Colin Millar.
}
