% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_utilities.R
\name{getSCurves}
\alias{getSCurves}
\title{Get Estimated Survival Curves from Semi-parametric Model for Interval Censored Data}
\usage{
getSCurves(fit, newdata = NULL)
}
\arguments{
\item{fit}{model fit with \code{ic_sp}}

\item{newdata}{data.frame containing covariates for which the survival curve will be fit to. 
Rownames from \code{newdata} will be used to name survival curve. 
If left blank, baseline covariates will be used}
}
\description{
Extracts the estimated survival curve(s) from an ic_sp or ic_np model for interval censored data.
}
\details{
Output will be a list with two elements: the first item will be \code{$Tbull_ints}, 
which is the Turnbull intervals. 
This is a k x 2 matrix, with the first column being the beginning of the 
Turnbull interval and the second being the end. 
This is necessary due to the \emph{representational non-uniqueness};
any survival curve that lies between the survival curves created from the
upper and lower limits of the Turnbull intervals will have equal likelihood. 
See example for proper display of this. The second item is \code{$S_curves}, 
or the estimated survival probability at each Turnbull interval for individuals 
with the covariates provided in \code{newdata}. Note that multiple rows may 
be provided to newdata, which will result in multiple S_curves.
}
\author{
Clifford Anderson-Bergman
}
