% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autopeek.R
\name{ic_autopeek}
\alias{ic_autopeek}
\alias{ic_autopeek.list}
\alias{ic_autopeek.data.frame}
\title{Get descriptive one-line summary of an object}
\usage{
ic_autopeek(object, ...)

\method{ic_autopeek}{list}(object, max_summary_length = cli::console_width(), ...)

\method{ic_autopeek}{data.frame}(object, max_summary_length = cli::console_width(), ...)
}
\arguments{
\item{object}{The object to be summarized.}

\item{...}{Other arguments passed to methods.}

\item{max_summary_length}{Integer. Maximum length of string summarizing the object. By default
this is set to the current terminal width.}
}
\value{
The function is mainly used for its side effects -- outputting to the terminal.
However, it also returns an invisible string of the printed summary.
}
\description{
This function is created as a modification of \code{\link[utils:str]{utils::str()}} function. It is supposed to
create more compacted yet informative summary about an object. It's default value of
"icecream.peeking.function"
}
\details{
This is a generic function. Default method simply calls \code{utils::str} function.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: Method for list

\item \code{data.frame}: Method for data.frame
}}

\seealso{
\code{\link[utils:str]{utils::str()}} \code{\link[=ic_peek]{ic_peek()}}
}
