% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{fit_predict}
\alias{fit_predict}
\title{Fit a reward estimation model on features, treatments and outcomes and
return predicted counterfactual rewards for each observation.}
\usage{
fit_predict(lnr, X, treatments, outcomes)
}
\arguments{
\item{lnr}{The learner or grid to use for imputation}

\item{X}{The features of the data.}

\item{treatments}{The treatment applied to each point in the data.}

\item{outcomes}{The outcome observed for each point in the data.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v2.0.0/IAIBase/reference/#IAI.fit_predict!}{\code{IAI.fit_predict!}}
}
\examples{
\donttest{
X <- iris
X[1, 1] <- NA
grid <- iai::grid_search(
    iai::imputation_learner(),
    method = c("opt_knn", "opt_tree"),
)
iai::fit_transform(grid, X)
}
}
