% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{intersect.samples}
\alias{intersect.samples}
\title{Intersect samples between datasets.}
\usage{
intersect.samples(data)
}
\arguments{
\item{data}{A list of data matrices. The data matrices need to have rownames.}
}
\value{
A list with of data matrices, all with the same set of samples.
}
\description{
In order to make all datasets comparable, we have to make sure they describe
the same set of samples. This function takes a list of datasets (i.e. data matrices),
takes the intersect of all rownames, and returns a list of datasets with only
those samples.
}
\examples{
set.seed(2)
n = 100
p = 100
x1 = matrix(rnorm(n*p), n, p)
x2 = matrix(rnorm(n*p), n, p)
rownames(x1) = rownames(x2) = paste0("X",1:n)
data = list(x1=x1[1:90,], x2=x2[10:100,])
data = intersect.samples(data)
}
