% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFun.R
\name{ggEvenness}
\alias{ggEvenness}
\title{ggplot for depicting evenness profiles}
\usage{
ggEvenness(output)
}
\arguments{
\item{output}{output obtained from the function \code{Evenness}.}
}
\value{
a figure depicting the estimated (or observed) evenness with respect to order q.
}
\description{
\code{ggEvenness} is a \code{ggplot2} extension for \code{Evenness} object to plot evenness with order q.
}
\examples{
## Evenness profiles for abundance data
# The observed evenness profile for abundance data
data(Data_spider)
Even_out1_obs <- Evenness(data = Data_spider, datatype = "abundance", 
                    method = "Observed", E.class = 1:5)
ggEvenness(Even_out1_obs)

\donttest{
# The estimated evenness profile for abundance data with default sample coverage value
data(Data_spider)
Even_out1_est <- Evenness(data = Data_spider, datatype = "abundance", 
                          method = "Estimated", SC = NULL, E.class = 1:5)
ggEvenness(Even_out1_est)
}

## Evenness profiles for incidence raw data
# The observed evenness profile for incidence data
data(Data_woody_plant)
Even_out2_obs <- Evenness(data = Data_woody_plant, datatype = "incidence_raw", 
                    method = "Observed", E.class = 1:5)
ggEvenness(Even_out2_obs)

\donttest{
# The estimated evenness profile for incidence data with user's specified coverage value of 0.98
data(Data_woody_plant)
Even_out2_est <- Evenness(data = Data_woody_plant, datatype = "incidence_raw", 
                          method = "Estimated", SC = 0.98, E.class = 1:5)
ggEvenness(Even_out2_est)
}

}
