/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;

public class SquareMathFunction
implements MathFunctionWithFirstDerivative {
    private MathFunction func;
    private double a;
    private double b;

    public SquareMathFunction(MathFunction func) {
        this(func, 1.0, 0.0);
    }

    public SquareMathFunction(MathFunction func, double a, double b) {
        if (func == null) {
            throw new NullPointerException();
        }
        this.func = func;
        this.a = a;
        this.b = b;
    }

    public MathFunction getFunction() {
        return this.func;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double evaluate(double x) {
        double v = this.a * this.func.evaluate(x) + this.b;
        return v * v;
    }

    public double derivative(double x) {
        double fder = MathFunctionUtil.derivative(this.func, x);
        return 2.0 * this.a * (this.a * this.func.evaluate(x) + this.b) * fder;
    }
}

