/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.HypergeometricDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.RandomStream;

public class HypergeometricGen
extends RandomVariateGenInt {
    private int m;
    private int l;
    private int k;

    public HypergeometricGen(RandomStream s, int m, int l, int k) {
        super(s, new HypergeometricDist(m, l, k));
        this.setParams(m, l, k);
    }

    public HypergeometricGen(RandomStream s, HypergeometricDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getM(), dist.getL(), dist.getK());
        }
    }

    public static int nextInt(RandomStream s, int m, int l, int k) {
        return HypergeometricDist.inverseF(m, l, k, s.nextDouble());
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public int getK() {
        return this.k;
    }

    protected void setParams(int m, int l, int k) {
        if (l <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (m <= 0 || m > l) {
            throw new IllegalArgumentException("m is invalid: 1<=m<l");
        }
        if (k <= 0 || k > l) {
            throw new IllegalArgumentException("k is invalid: 1<=k<l");
        }
        this.m = m;
        this.l = l;
        this.k = k;
    }
}

