/*
 * Decompiled with CFR 0.152.
 */
package mrmc.core;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import mrmc.chart.XYPair;
import mrmc.core.DBRecord;
import mrmc.core.MRMC;
import mrmc.gui.GUInterface;
import mrmc.gui.SizePanel;

public class InputFile {
    TreeMap<String, TreeMap<String, TreeMap<String, Double>>> keyedData = new TreeMap();
    public TreeMap<String, TreeMap<String, Integer[]>> casecount = new TreeMap();
    final TreeMap<String, TreeMap<String, ArrayList<String>>> modinformation = new TreeMap();
    TreeMap<String, Integer> truthVals = new TreeMap();
    public long Nreader = 0L;
    public long Nnormal = 0L;
    public long Ndisease = 0L;
    public long Nmodality;
    public TreeMap<String, Integer> readerIDs = new TreeMap();
    public TreeMap<String, Integer> normalIDs = new TreeMap();
    public TreeMap<String, Integer> diseaseIDs = new TreeMap();
    public TreeMap<String, Integer> caseIDs = new TreeMap();
    public TreeMap<String, Integer> modalityIDs = new TreeMap();
    public String filePathAndName;
    public String filePath;
    public String fileName;
    public SizePanel SizePanel1;
    private GUInterface GUI;
    private DBRecord DBRecordStat;
    ArrayList<String> fileContent = new ArrayList();
    int NlinesFileContent;
    int filePosition;
    int summaryPosition;
    int beginSummaryPosition = 0;
    int endSummaryPosition = 0;
    public int NrowsInHeader = 0;
    public String recordTitle = "Default Record Title";
    public String fileHeader = "Default Record Title,\nAll rows of input file before BEGIN DATA:";
    public String[][] observerData;
    public boolean isLoaded = false;
    public String dataCheckResults = "";

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public String getRecordTitle() {
        return this.recordTitle;
    }

    public String getDesc() {
        return this.fileHeader;
    }

    public ArrayList<String> getReaderIDs() {
        ArrayList<String> desc = new ArrayList<String>();
        for (String desc_temp : this.readerIDs.keySet()) {
            desc.add(desc_temp);
        }
        return desc;
    }

    public ArrayList<String> getNormalIDs() {
        ArrayList<String> desc = new ArrayList<String>();
        for (String desc_temp : this.normalIDs.keySet()) {
            desc.add(desc_temp);
        }
        return desc;
    }

    public ArrayList<String> getDiseaseIDs() {
        ArrayList<String> desc = new ArrayList<String>();
        for (String desc_temp : this.diseaseIDs.keySet()) {
            desc.add(desc_temp);
        }
        return desc;
    }

    public ArrayList<String> getModalityIDs() {
        ArrayList<String> desc = new ArrayList<String>();
        for (String desc_temp : this.modalityIDs.keySet()) {
            desc.add(desc_temp);
        }
        return desc;
    }

    public double getMaxScore(String mod) {
        double max = Double.MIN_VALUE;
        for (String r : this.keyedData.keySet()) {
            for (String c : this.keyedData.get(r).keySet()) {
                if (this.keyedData.get(r).get(c).get(mod) == null || !(this.keyedData.get(r).get(c).get(mod) > max)) continue;
                max = this.keyedData.get(r).get(c).get(mod);
            }
        }
        return max;
    }

    public double getMinScore(String mod) {
        double min = Double.MAX_VALUE;
        for (String r : this.keyedData.keySet()) {
            for (String c : this.keyedData.get(r).keySet()) {
                if (this.keyedData.get(r).get(c).get(mod) == null || !(this.keyedData.get(r).get(c).get(mod) < min)) continue;
                min = this.keyedData.get(r).get(c).get(mod);
            }
        }
        return min;
    }

    public TreeMap<String, TreeMap<String, TreeSet<XYPair>>> generateROCpoints(String[] modchosen) {
        int samples = 100;
        TreeMap<String, TreeMap<String, TreeSet<XYPair>>> allrocPoints = new TreeMap<String, TreeMap<String, TreeSet<XYPair>>>();
        String[] stringArray = modchosen;
        int n = modchosen.length;
        int n2 = 0;
        while (n2 < n) {
            String mod = stringArray[n2];
            TreeMap rocPoints = new TreeMap();
            double min = this.getMinScore(mod);
            double max = this.getMaxScore(mod);
            double inc = (max - min) / (double)samples;
            for (String r : this.keyedData.keySet()) {
                double thresh = min - inc;
                while (thresh <= max + inc) {
                    int fp = 0;
                    int tp = 0;
                    int normCount = 0;
                    int disCount = 0;
                    for (String c : this.keyedData.get(r).keySet()) {
                        if (this.keyedData.get(r).get(c).isEmpty() || this.keyedData.get(r).get(c).get(mod) == null) continue;
                        double score = this.keyedData.get(r).get(c).get(mod);
                        int caseTruth = this.truthVals.get(c);
                        if (caseTruth == 0) {
                            ++normCount;
                            if (!(score > thresh)) continue;
                            ++fp;
                            continue;
                        }
                        ++disCount;
                        if (!(score > thresh)) continue;
                        ++tp;
                    }
                    double fpf = (double)fp / (double)normCount;
                    double tpf = (double)tp / (double)disCount;
                    if (normCount != 0 & disCount != 0) {
                        if (rocPoints.containsKey(r)) {
                            ((TreeSet)rocPoints.get(r)).add(new XYPair(fpf, tpf));
                        } else {
                            TreeSet<XYPair> temp = new TreeSet<XYPair>();
                            temp.add(new XYPair(fpf, tpf));
                            rocPoints.put(r, temp);
                        }
                    }
                    thresh += inc;
                }
            }
            allrocPoints.put(mod, rocPoints);
            ++n2;
        }
        return allrocPoints;
    }

    public TreeMap<String, TreeSet<XYPair>> generatePooledROC(String[] rocModchosen) {
        int samples = 100;
        TreeMap<String, TreeSet<XYPair>> allpooledCurve = new TreeMap<String, TreeSet<XYPair>>();
        String[] stringArray = rocModchosen;
        int n = rocModchosen.length;
        int n2 = 0;
        while (n2 < n) {
            String rocMod = stringArray[n2];
            double min = this.getMinScore(rocMod);
            double max = this.getMaxScore(rocMod);
            double inc = (max - min) / (double)samples;
            TreeSet<XYPair> pooledCurve = new TreeSet<XYPair>();
            double thresh = min - inc;
            while (thresh <= max + inc) {
                int fp = 0;
                int tp = 0;
                int normCount = 0;
                int disCount = 0;
                for (String r : this.keyedData.keySet()) {
                    for (String c : this.keyedData.get(r).keySet()) {
                        if (this.keyedData.get(r).get(c).isEmpty() || this.keyedData.get(r).get(c).get(rocMod) == null) continue;
                        double score = this.keyedData.get(r).get(c).get(rocMod);
                        int caseTruth = this.truthVals.get(c);
                        if (caseTruth == 0) {
                            ++normCount;
                            if (!(score > thresh)) continue;
                            ++fp;
                            continue;
                        }
                        ++disCount;
                        if (!(score > thresh)) continue;
                        ++tp;
                    }
                }
                double fpf = (double)fp / (double)normCount;
                double tpf = (double)tp / (double)disCount;
                pooledCurve.add(new XYPair(fpf, tpf));
                thresh += inc;
            }
            allpooledCurve.put(rocMod, pooledCurve);
            ++n2;
        }
        return allpooledCurve;
    }

    public TreeMap<String, Double> readersPerCase() {
        TreeMap<String, Double> rpc = new TreeMap<String, Double>();
        for (String r : this.keyedData.keySet()) {
            for (String c : this.keyedData.get(r).keySet()) {
                if (this.keyedData.get(r).get(c).isEmpty()) continue;
                if (rpc.get(c) == null) {
                    rpc.put(c, 1.0);
                    continue;
                }
                rpc.put(c, rpc.get(c) + 1.0);
            }
        }
        return rpc;
    }

    public TreeMap<String, Double> casesPerReader() {
        TreeMap<String, Double> cpr = new TreeMap<String, Double>();
        for (String r : this.keyedData.keySet()) {
            for (String c : this.keyedData.get(r).keySet()) {
                if (this.keyedData.get(r).get(c).isEmpty()) continue;
                if (cpr.get(r) == null) {
                    cpr.put(r, 1.0);
                    continue;
                }
                cpr.put(r, cpr.get(r) + 1.0);
            }
        }
        return cpr;
    }

    public ArrayList<ArrayList<String>> getN0N1CaseNums() {
        ArrayList<ArrayList<String>> toReturn = new ArrayList<ArrayList<String>>();
        toReturn.add(this.getNormalIDs());
        toReturn.add(this.getDiseaseIDs());
        return toReturn;
    }

    public TreeMap<String, String[][]> getStudyDesign(String modalityID) {
        String[][] design = new String[(int)this.Nreader][(int)(this.Nnormal + this.Ndisease + 1L)];
        String[][] readerrelation = new String[(int)this.Nreader][2];
        String[][] caserelation = new String[(int)(this.Nnormal + this.Ndisease)][2];
        TreeMap<String, String[][]> StudyDesignData = new TreeMap<String, String[][]>();
        int r = 0;
        int i = 0;
        for (String readerID : this.keyedData.keySet()) {
            i = 0;
            design[r][i] = readerID;
            for (String caseID : this.keyedData.get(readerID).keySet()) {
                if (r == 0) {
                    caserelation[i][0] = Integer.toString(i + 1);
                    caserelation[i][1] = caseID;
                }
                ++i;
                design[r][i] = this.keyedData.get(readerID).get(caseID).get(modalityID) != null ? "true" : "false";
            }
            readerrelation[r][0] = Integer.toString(r);
            readerrelation[r][1] = readerID;
            ++r;
        }
        StudyDesignData.put("readerrelation", readerrelation);
        StudyDesignData.put("caserelation", caserelation);
        StudyDesignData.put("data", design);
        return StudyDesignData;
    }

    public void ReadInputFile(GUInterface GUInterface_temp) throws IOException {
        this.GUI = GUInterface_temp;
        try {
            FileInputStream fstream = new FileInputStream(this.filePathAndName);
            DataInputStream din = new DataInputStream(fstream);
            InputStreamReader isr = new InputStreamReader(din);
            BufferedReader br = new BufferedReader(isr);
            try {
                String inputformat = this.filePathAndName.substring(this.filePathAndName.lastIndexOf(".") + 1);
                if (inputformat.equals("csv") || inputformat.equals("imrmc") || inputformat.equals("omrmc")) {
                    String strtemp;
                    while ((strtemp = br.readLine()) != null) {
                        if (strtemp.length() > 0 && strtemp.substring(strtemp.length() - 2).equals(",,")) {
                            strtemp = strtemp.substring(0, strtemp.indexOf(",,"));
                        }
                        if (strtemp.length() > 0 && strtemp.substring(strtemp.length() - 1).equals(",")) {
                            strtemp = strtemp.substring(0, strtemp.length() - 1);
                        }
                        this.fileContent.add(strtemp);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.GUI.MRMCobject.getFrame(), "Please choose .imrmc, .omrmc or .csv format inputfile.", "Error", 0);
                    return;
                }
                din.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("read record Error in inputFile.java: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("Error reading file" + this.filePathAndName + e.getMessage());
            return;
        }
        this.NlinesFileContent = this.fileContent.size();
        if (GUInterface.selectedInput == "Reader study data") {
            this.filePosition = 0;
            this.getExperimentSizeFromHeader();
            this.observerData = new String[this.NlinesFileContent - (this.filePosition + 1)][4];
            this.parseObserverData();
            boolean VerboseTrue = true;
            boolean DisplayWarning = !MRMC.commandStart;
            this.verifySizesAndGetIDs(VerboseTrue, DisplayWarning);
            this.processScoresAndTruth(VerboseTrue);
            System.out.println("Input Raw File Successfully Read!");
            this.isLoaded = true;
        }
        if (GUInterface.selectedInput == "Summary info from a reader study") {
            this.summaryPosition = 0;
            this.findSummaryBegin();
            this.findSummaryEnd();
            this.DBRecordStat = this.GUI.DBRecordStat;
            this.loadSummaryData();
            System.out.println("Input Summary File Successfully Read!");
            this.isLoaded = true;
        }
    }

    private void findSummaryBegin() throws IOException {
        String toReturn = "";
        String tempstr = this.fileContent.get(0).toUpperCase();
        int dataloc = tempstr.indexOf("BEGIN SUMMARY");
        while (dataloc != 0) {
            try {
                ++this.summaryPosition;
                tempstr = this.fileContent.get(this.summaryPosition).toUpperCase();
                dataloc = tempstr.indexOf("BEGIN SUMMARY");
            }
            catch (Exception e) {
                toReturn = "ERROR: Can't find BEGIN SUMMARY";
                throw new IOException(toReturn, e);
            }
        }
        this.beginSummaryPosition = this.summaryPosition;
    }

    private void findSummaryEnd() throws IOException {
        String toReturn = "";
        String tempstr = this.fileContent.get(0).toUpperCase();
        int dataloc = tempstr.indexOf("END SUMMARY");
        while (dataloc != 0) {
            try {
                ++this.summaryPosition;
                tempstr = this.fileContent.get(this.summaryPosition).toUpperCase();
                dataloc = tempstr.indexOf("END SUMMARY");
            }
            catch (Exception e) {
                toReturn = "ERROR: Can't find END SUMMARY";
                throw new IOException(toReturn, e);
            }
        }
        this.endSummaryPosition = this.summaryPosition;
    }

    private void loadSummaryData() throws IOException {
        String toReturn = "";
        this.DBRecordStat.AUCsReaderAvg = new double[3];
        String tempstr = this.fileContent.get(this.beginSummaryPosition + 1).toUpperCase();
        try {
            this.DBRecordStat.Nreader = Integer.valueOf(tempstr.substring(tempstr.lastIndexOf("=") + 1).trim()).intValue();
            this.DBRecordStat.NreaderDB = Integer.valueOf(tempstr.substring(tempstr.lastIndexOf("=") + 1).trim()).intValue();
        }
        catch (NumberFormatException e) {
            toReturn = "Found NReaderSize =: Text following is not an integer \n" + tempstr;
            throw new IOException(toReturn);
        }
        tempstr = this.fileContent.get(this.beginSummaryPosition + 2).toUpperCase();
        try {
            this.DBRecordStat.Nnormal = Integer.valueOf(tempstr.substring(tempstr.lastIndexOf("=") + 1).trim()).intValue();
            this.DBRecordStat.NnormalDB = Integer.valueOf(tempstr.substring(tempstr.lastIndexOf("=") + 1).trim()).intValue();
        }
        catch (NumberFormatException e) {
            toReturn = "Found NReaderSize =: Text following is not an integer \n" + tempstr;
            throw new IOException(toReturn);
        }
        tempstr = this.fileContent.get(this.beginSummaryPosition + 3).toUpperCase();
        try {
            this.DBRecordStat.Ndisease = Integer.valueOf(tempstr.substring(tempstr.lastIndexOf("=") + 1).trim()).intValue();
            this.DBRecordStat.NdiseaseDB = Integer.valueOf(tempstr.substring(tempstr.lastIndexOf("=") + 1).trim()).intValue();
        }
        catch (NumberFormatException e) {
            toReturn = "Found NReaderSize =: Text following is not an integer \n" + tempstr;
            throw new IOException(toReturn);
        }
        tempstr = this.fileContent.get(this.beginSummaryPosition + 5).toUpperCase();
        try {
            this.DBRecordStat.modalityA = tempstr.substring(tempstr.lastIndexOf("=") + 1).trim();
        }
        catch (NumberFormatException e) {
            toReturn = "Fail to load Modality A information \n" + tempstr;
            throw new IOException(toReturn);
        }
        tempstr = this.fileContent.get(this.beginSummaryPosition + 6).toUpperCase();
        try {
            this.DBRecordStat.modalityB = tempstr.substring(tempstr.lastIndexOf("=") + 1).trim();
        }
        catch (NumberFormatException e) {
            toReturn = "Fail to load Modality B information \n" + tempstr;
            throw new IOException(toReturn);
        }
        this.DBRecordStat.AUCs = new double[(int)this.DBRecordStat.Nreader][3];
        this.DBRecordStat.N0perReader = new int[(int)this.DBRecordStat.Nreader][3];
        this.DBRecordStat.N1perReader = new int[(int)this.DBRecordStat.Nreader][3];
        this.DBRecordStat.readerVarA = new double[(int)this.DBRecordStat.Nreader];
        this.DBRecordStat.readerVarB = new double[(int)this.DBRecordStat.Nreader];
        this.DBRecordStat.readerTotalVar = new double[(int)this.DBRecordStat.Nreader];
        int i = this.beginSummaryPosition + 7;
        while (i < this.endSummaryPosition + 1) {
            String tstr;
            int j;
            tempstr = this.fileContent.get(i).toUpperCase().trim();
            int loc = tempstr.indexOf("AUC_A =");
            if (loc == 0) {
                try {
                    this.DBRecordStat.AUCsReaderAvg[0] = Double.valueOf(tempstr.substring(tempstr.lastIndexOf("=") + 1).trim());
                }
                catch (NumberFormatException e) {
                    toReturn = "Found AUC_A =: Text following is not an number \n" + tempstr;
                    throw new IOException(toReturn);
                }
            }
            if ((loc = tempstr.indexOf("AUC_B =")) == 0) {
                try {
                    this.DBRecordStat.AUCsReaderAvg[1] = Double.valueOf(tempstr.substring(tempstr.lastIndexOf("=") + 1).trim());
                }
                catch (NumberFormatException e) {
                    toReturn = "Found AUC_B =: Text following is not an number \n" + tempstr;
                    throw new IOException(toReturn);
                }
            }
            if ((loc = tempstr.indexOf("MOD A")) != -1) {
                int k = 2;
                while ((long)k < this.DBRecordStat.Nreader + 2L) {
                    tempstr = this.fileContent.get(i + k).toUpperCase().trim();
                    String[] tempAUCs = this.fileContent.get(i + k).split(",");
                    this.readerIDs.put(tempAUCs[0].trim(), k - 2);
                    try {
                        this.DBRecordStat.N0perReader[k - 2][0] = Integer.valueOf(tempAUCs[1].trim());
                        this.DBRecordStat.N1perReader[k - 2][0] = Integer.valueOf(tempAUCs[2].trim());
                        this.DBRecordStat.AUCs[k - 2][0] = Double.valueOf(tempAUCs[3].trim());
                        this.DBRecordStat.readerVarA[k - 2] = Double.valueOf(tempAUCs[4].trim());
                    }
                    catch (Exception e) {
                        toReturn = "ERROR: Invalid input of AUCs";
                        toReturn = String.valueOf(toReturn) + "      row = " + (i + k + 1) + " \n";
                        toReturn = String.valueOf(toReturn) + this.fileContent.get(i + k) + " \n";
                        throw new IOException(toReturn, e);
                    }
                    ++k;
                }
            }
            if ((loc = tempstr.indexOf("MOD B")) != -1) {
                int k = 2;
                while ((long)k < this.DBRecordStat.Nreader + 2L) {
                    tempstr = this.fileContent.get(i + k).toUpperCase().trim();
                    String[] tempAUCs = this.fileContent.get(i + k).split(",");
                    this.readerIDs.put(tempAUCs[0].trim(), k - 2);
                    try {
                        this.DBRecordStat.N0perReader[k - 2][1] = Integer.valueOf(tempAUCs[1].trim());
                        this.DBRecordStat.N1perReader[k - 2][1] = Integer.valueOf(tempAUCs[2].trim());
                        this.DBRecordStat.AUCs[k - 2][1] = Double.valueOf(tempAUCs[3].trim());
                        this.DBRecordStat.readerVarB[k - 2] = Double.valueOf(tempAUCs[4].trim());
                    }
                    catch (Exception e) {
                        toReturn = "ERROR: Invalid input of AUCs";
                        toReturn = String.valueOf(toReturn) + "      row = " + (i + k + 1) + " \n";
                        toReturn = String.valueOf(toReturn) + this.fileContent.get(i + k) + " \n";
                        throw new IOException(toReturn, e);
                    }
                    ++k;
                }
            }
            if ((loc = tempstr.indexOf("DIFFERENCE BETWEEN MODS A AND B")) != -1) {
                int k = 2;
                while ((long)k < this.DBRecordStat.Nreader + 2L) {
                    tempstr = this.fileContent.get(i + k).toUpperCase().trim();
                    String[] tempAUCs = this.fileContent.get(i + k).split(",");
                    this.readerIDs.put(tempAUCs[0].trim(), k - 2);
                    try {
                        this.DBRecordStat.N0perReader[k - 2][2] = Integer.valueOf(tempAUCs[1].trim());
                        this.DBRecordStat.N1perReader[k - 2][2] = Integer.valueOf(tempAUCs[2].trim());
                        this.DBRecordStat.AUCs[k - 2][2] = Double.valueOf(tempAUCs[3].trim());
                        this.DBRecordStat.readerTotalVar[k - 2] = Double.valueOf(tempAUCs[4].trim());
                    }
                    catch (Exception e) {
                        toReturn = "ERROR: Invalid input of AUCs";
                        toReturn = String.valueOf(toReturn) + "      row = " + (i + k + 1) + " \n";
                        toReturn = String.valueOf(toReturn) + this.fileContent.get(i + k) + " \n";
                        throw new IOException(toReturn, e);
                    }
                    ++k;
                }
            }
            if ((loc = tempstr.indexOf("MODALITY1(AUC_A)")) != -1) {
                String[] studyinfo = this.fileContent.get(i).split(",");
                j = 1;
                while (j < studyinfo.length) {
                    try {
                        tstr = studyinfo[j];
                        this.DBRecordStat.LoadBDG[0][j - 1] = Double.valueOf(tstr.trim());
                    }
                    catch (Exception e) {
                        toReturn = "ERROR: Invalid input of MODALITY1(AUC_A)";
                        toReturn = String.valueOf(toReturn) + "      row = " + (i + 1) + " \n";
                        toReturn = String.valueOf(toReturn) + this.fileContent.get(i) + " \n";
                        throw new IOException(toReturn, e);
                    }
                    ++j;
                }
            }
            if ((loc = tempstr.indexOf("MODALITY2(AUC_B)")) != -1) {
                String[] studyinfo = this.fileContent.get(i).split(",");
                j = 1;
                while (j < studyinfo.length) {
                    try {
                        tstr = studyinfo[j];
                        this.DBRecordStat.LoadBDG[1][j - 1] = Double.valueOf(tstr.trim());
                    }
                    catch (Exception e) {
                        toReturn = "ERROR: Invalid input of MODALITY2(AUC_B)";
                        toReturn = String.valueOf(toReturn) + "      row = " + (i + 1) + " \n";
                        toReturn = String.valueOf(toReturn) + this.fileContent.get(i) + " \n";
                        throw new IOException(toReturn, e);
                    }
                    ++j;
                }
            }
            if ((loc = tempstr.indexOf("COMP PRODUCT")) != -1) {
                String[] studyinfo = this.fileContent.get(i).split(",");
                j = 1;
                while (j < studyinfo.length) {
                    try {
                        tstr = studyinfo[j];
                        this.DBRecordStat.LoadBDG[2][j - 1] = Double.valueOf(tstr.trim());
                    }
                    catch (Exception e) {
                        toReturn = "ERROR: Invalid input of COMP PRODUCT";
                        toReturn = String.valueOf(toReturn) + "      row = " + (i + 1) + " \n";
                        toReturn = String.valueOf(toReturn) + this.fileContent.get(i) + " \n";
                        throw new IOException(toReturn, e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.DBRecordStat.AUCsReaderAvg[2] = this.DBRecordStat.AUCsReaderAvg[0] - this.DBRecordStat.AUCsReaderAvg[1];
        if (this.DBRecordStat.AUCsReaderAvg[0] != 0.0 & this.DBRecordStat.AUCsReaderAvg[1] == 0.0) {
            this.DBRecordStat.inputMod = 0;
        }
        if (this.DBRecordStat.AUCsReaderAvg[1] != 0.0 & this.DBRecordStat.AUCsReaderAvg[0] == 0.0) {
            this.DBRecordStat.inputMod = 1;
        }
        if (this.DBRecordStat.AUCsReaderAvg[1] != 0.0 & this.DBRecordStat.AUCsReaderAvg[0] != 0.0) {
            this.DBRecordStat.inputMod = 2;
        }
    }

    private void getExperimentSizeFromHeader() throws IOException {
        this.recordTitle = this.fileContent.get(0);
        String tempstr = this.fileContent.get(0).toUpperCase();
        int dataloc = tempstr.indexOf("BEGIN DATA:");
        String toReturn = "";
        while (dataloc != 0) {
            this.fileHeader = String.valueOf(this.fileHeader) + this.fileContent.get(this.filePosition) + "\n";
            tempstr = this.fileContent.get(this.filePosition).toUpperCase();
            int loc = tempstr.indexOf("N0:");
            if (loc != -1) {
                System.out.println("Found N0: in header. N0=" + tempstr.substring(3));
                try {
                    this.Nnormal = Integer.valueOf(tempstr.substring(3).trim()).intValue();
                }
                catch (NumberFormatException e) {
                    toReturn = "Found N0: Text following is not an integer \n" + tempstr;
                    throw new IOException(toReturn);
                }
            }
            if ((loc = tempstr.indexOf("N1:")) != -1) {
                System.out.println("Found N1: in header. N1=" + tempstr.substring(3));
                try {
                    this.Ndisease = Integer.valueOf(tempstr.substring(3).trim()).intValue();
                }
                catch (NumberFormatException e) {
                    toReturn = "Found N1: Text following is not an integer \n" + tempstr;
                    throw new IOException(toReturn);
                }
            }
            if ((loc = tempstr.indexOf("NR:")) != -1) {
                System.out.println("Found NR: in header. NR=" + tempstr.substring(3));
                try {
                    this.Nreader = Integer.valueOf(tempstr.substring(3).trim()).intValue();
                }
                catch (NumberFormatException e) {
                    toReturn = "Found NR: Text following is not an integer \n" + tempstr;
                    throw new IOException(toReturn);
                }
            }
            if ((loc = tempstr.indexOf("NM:")) != -1) {
                System.out.println("Found NM: in header. NM=" + tempstr.substring(3));
                try {
                    this.Nmodality = Integer.valueOf(tempstr.substring(3).trim()).intValue();
                }
                catch (NumberFormatException e) {
                    toReturn = "Found NM: Text following is not an integer \n" + tempstr;
                    throw new IOException(toReturn);
                }
            }
            try {
                ++this.filePosition;
                tempstr = this.fileContent.get(this.filePosition).toUpperCase();
                dataloc = tempstr.indexOf("BEGIN DATA:");
            }
            catch (Exception e) {
                toReturn = "ERROR: Can't find BEGIN DATA";
                throw new IOException(toReturn, e);
            }
        }
        this.NrowsInHeader = this.filePosition;
        System.out.println("a total of " + this.NrowsInHeader + " lines in header");
    }

    private void parseObserverData() throws IOException {
        int i = 0;
        while (i < this.NlinesFileContent - (this.filePosition + 1)) {
            String[] tempNumbers = this.fileContent.get(this.filePosition + 1 + i).split(",");
            try {
                this.observerData[i][0] = String.valueOf(tempNumbers[0]).replaceAll("\\s", "");
                this.observerData[i][1] = String.valueOf(tempNumbers[1]).replaceAll("\\s", "");
                this.observerData[i][2] = String.valueOf(tempNumbers[2]).replaceAll("\\s", "");
                this.observerData[i][3] = String.valueOf(tempNumbers[3]).replaceAll("\\s", "");
            }
            catch (Exception e) {
                String toReturn = "ERROR: Invalid input";
                toReturn = String.valueOf(toReturn) + "      row = " + (this.NrowsInHeader + i + 2) + " \n";
                toReturn = String.valueOf(toReturn) + this.fileContent.get(this.filePosition + 1 + i) + " \n";
                throw new IOException(toReturn, e);
            }
            ++i;
        }
    }

    public void verifySizesAndGetIDs(boolean verbose, boolean DisplayWarning) throws IOException {
        Integer in0 = -1;
        Integer in1 = -1;
        Integer inr = -1;
        Integer inm = -1;
        int i = 0;
        while (i < this.observerData.length) {
            if (this.observerData[i][0] == null) break;
            if (this.observerData[i][0].equals("truth") || this.observerData[i][0].equals("-1")) {
                if (this.normalIDs.containsKey(this.observerData[i][1]) || this.diseaseIDs.containsKey(this.observerData[i][1])) {
                    this.dataCheckResults = "ERROR: Duplicate case found \n";
                    this.dataCheckResults = String.valueOf(this.dataCheckResults) + "      row = " + (this.NrowsInHeader + i + 2) + " \n";
                    this.dataCheckResults = String.valueOf(this.dataCheckResults) + "Check for an earlier occurrence:" + " \n";
                    this.dataCheckResults = String.valueOf(this.dataCheckResults) + "      readerID = " + this.observerData[i][0] + " \n";
                    this.dataCheckResults = String.valueOf(this.dataCheckResults) + "      caseID = " + this.observerData[i][1] + " \n";
                    this.dataCheckResults = String.valueOf(this.dataCheckResults) + "      modalityID = " + this.observerData[i][2] + " \n";
                    throw new IOException(this.dataCheckResults);
                }
                if (!this.normalIDs.containsKey(this.observerData[i][1]) && this.observerData[i][3].equals("0")) {
                    this.normalIDs.put(this.observerData[i][1], in0);
                }
                if (!this.diseaseIDs.containsKey(this.observerData[i][1]) && this.observerData[i][3].equals("1")) {
                    this.diseaseIDs.put(this.observerData[i][1], in1);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.observerData.length) {
            if (this.observerData[i][0] == null) break;
            if (!this.observerData[i][0].equals("truth") && !this.observerData[i][0].equals("-1")) {
                Integer[] countnum;
                if (!this.normalIDs.containsKey(this.observerData[i][1]) && !this.diseaseIDs.containsKey(this.observerData[i][1])) {
                    this.dataCheckResults = "ERROR: No truth for case \n";
                    this.dataCheckResults = String.valueOf(this.dataCheckResults) + "      row = " + (this.NrowsInHeader + i + 2) + " \n";
                    this.dataCheckResults = String.valueOf(this.dataCheckResults) + "      readerID = " + this.observerData[i][0] + " \n";
                    this.dataCheckResults = String.valueOf(this.dataCheckResults) + "      caseID = " + this.observerData[i][1] + " \n";
                    this.dataCheckResults = String.valueOf(this.dataCheckResults) + "      modalityID = " + this.observerData[i][2] + " \n";
                    throw new IOException(this.dataCheckResults);
                }
                if (!this.readerIDs.containsKey(this.observerData[i][0])) {
                    this.readerIDs.put(this.observerData[i][0], inr);
                }
                if (!this.modalityIDs.containsKey(this.observerData[i][2])) {
                    this.modalityIDs.put(this.observerData[i][2], inm);
                    this.casecount.put(this.observerData[i][2], new TreeMap());
                }
                if (!this.casecount.get(this.observerData[i][2]).containsKey(this.observerData[i][0])) {
                    Integer[] startnum = new Integer[]{0, 0};
                    this.casecount.get(this.observerData[i][2]).put(this.observerData[i][0], startnum);
                }
                if (this.normalIDs.containsKey(this.observerData[i][1])) {
                    countnum = this.casecount.get(this.observerData[i][2]).get(this.observerData[i][0]);
                    countnum[0] = countnum[0] + 1;
                    this.casecount.get(this.observerData[i][2]).put(this.observerData[i][0], countnum);
                }
                if (this.diseaseIDs.containsKey(this.observerData[i][1])) {
                    countnum = this.casecount.get(this.observerData[i][2]).get(this.observerData[i][0]);
                    countnum[1] = countnum[1] + 1;
                    this.casecount.get(this.observerData[i][2]).put(this.observerData[i][0], countnum);
                }
            }
            ++i;
        }
        for (String ID : this.readerIDs.keySet()) {
            inr = inr + 1;
            this.readerIDs.put(ID, inr);
        }
        if (verbose) {
            System.out.println("readerIDs: " + this.readerIDs);
        }
        if (this.Nreader != (long)this.readerIDs.size()) {
            this.dataCheckResults = String.valueOf(this.dataCheckResults) + "NR Given = " + this.Nreader + " NR Found = " + this.readerIDs.size() + " \n";
            this.Nreader = this.readerIDs.size();
        }
        for (String ID : this.normalIDs.keySet()) {
            in0 = in0 + 1;
            this.normalIDs.put(ID, in0);
        }
        if (verbose) {
            System.out.println("normalIDs: " + this.normalIDs);
        }
        if (this.Nnormal != (long)this.normalIDs.size()) {
            this.dataCheckResults = String.valueOf(this.dataCheckResults) + "N0 Given = " + this.Nnormal + " N0 Found = " + this.normalIDs.size() + " \n";
            this.Nnormal = this.normalIDs.size();
        }
        for (String ID : this.diseaseIDs.keySet()) {
            in1 = in1 + 1;
            this.diseaseIDs.put(ID, in1);
        }
        if (verbose) {
            System.out.println("diseaseIDs: " + this.diseaseIDs);
        }
        if (this.Ndisease != (long)this.diseaseIDs.size()) {
            this.dataCheckResults = String.valueOf(this.dataCheckResults) + "N1 Given = " + this.Ndisease + " N1 Found = " + this.diseaseIDs.size() + " \n";
            this.Ndisease = this.diseaseIDs.size();
        }
        for (String ID : this.modalityIDs.keySet()) {
            inm = inm + 1;
            this.modalityIDs.put(ID, inm);
        }
        if (verbose) {
            System.out.println("modalityIDs: " + this.modalityIDs);
        }
        if (this.Nmodality != (long)this.modalityIDs.size()) {
            this.dataCheckResults = String.valueOf(this.dataCheckResults) + "NM Given = " + this.Nmodality + " NM Found = " + this.modalityIDs.size();
            this.Nmodality = this.modalityIDs.size();
        }
        if (verbose) {
            System.out.println("caseIDs: " + this.caseIDs);
        }
        String misscasemessage = "";
        int messagecount = 0;
        for (String m : this.modalityIDs.keySet()) {
            for (String r : this.readerIDs.keySet()) {
                Integer[] countnum = this.casecount.get(m).get(r);
                if (countnum != null && Math.min(countnum[0], countnum[1]) >= 2) continue;
                misscasemessage = String.valueOf(misscasemessage) + "Reader: " + r + " reads less than 2 normal or less than 2 disease cases in " + "Modality: " + m + "\n";
                ++messagecount;
            }
        }
        if (messagecount > 0 && DisplayWarning) {
            misscasemessage = String.valueOf(misscasemessage) + "ROC analysis is not possible and not executed for these reader-modality combinations.";
            JFrame frame = new JFrame();
            JOptionPane.showMessageDialog(frame, misscasemessage, "Not fully data loaded", 1);
        }
    }

    public void processScoresAndTruth(boolean verbose) throws IOException {
        for (String r : this.readerIDs.keySet()) {
            this.keyedData.put(r, new TreeMap());
            for (String n : this.normalIDs.keySet()) {
                this.keyedData.get(r).put(n, new TreeMap());
            }
            for (String d : this.diseaseIDs.keySet()) {
                this.keyedData.get(r).put(d, new TreeMap());
            }
        }
        for (String m : this.modalityIDs.keySet()) {
            ArrayList readerlist = new ArrayList();
            ArrayList normallist = new ArrayList();
            ArrayList diseaselist = new ArrayList();
            this.modinformation.put(m, new TreeMap());
            this.modinformation.get(m).put("reader", readerlist);
            this.modinformation.get(m).put("normal", normallist);
            this.modinformation.get(m).put("disease", diseaselist);
        }
        Integer ic = 0;
        for (String desc : this.keyedData.get(this.keyedData.firstKey()).keySet()) {
            Integer n = ic;
            ic = n + 1;
            this.caseIDs.put(desc, n);
        }
        int i = 0;
        while (i < this.observerData.length) {
            if (this.observerData[i][0] == null) break;
            String readerID = this.observerData[i][0];
            String caseID = this.observerData[i][1];
            String modalityID = this.observerData[i][2];
            double score = Double.valueOf(this.observerData[i][3]);
            if (readerID.equals("truth") || readerID.equals("-1")) {
                this.truthVals.put(caseID, (int)Integer.valueOf(this.observerData[i][3]));
            } else {
                if (this.keyedData.get(readerID).get(caseID).containsKey(modalityID)) {
                    String toReturn = "ERROR: Replicate observation found \n";
                    toReturn = String.valueOf(toReturn) + "      row = " + (this.NrowsInHeader + i + 2) + " \n";
                    toReturn = String.valueOf(toReturn) + "Check for an earlier occurrence: " + " \n";
                    toReturn = String.valueOf(toReturn) + "      readerID = " + this.observerData[i][0] + " \n";
                    toReturn = String.valueOf(toReturn) + "      caseID = " + this.observerData[i][1] + " \n";
                    toReturn = String.valueOf(toReturn) + "      modalityID = " + this.observerData[i][2] + " \n";
                    throw new IOException(toReturn);
                }
                Integer[] countnum = this.casecount.get(modalityID).get(readerID);
                if (Math.min(countnum[0], countnum[1]) > 2) {
                    this.keyedData.get(readerID).get(caseID).put(modalityID, score);
                    if (!this.modinformation.get(modalityID).get("reader").contains(readerID)) {
                        this.modinformation.get(modalityID).get("reader").add(readerID);
                    }
                    if (this.normalIDs.containsKey(caseID) & !this.modinformation.get(modalityID).get("normal").contains(caseID)) {
                        this.modinformation.get(modalityID).get("normal").add(caseID);
                    }
                    if (this.diseaseIDs.containsKey(caseID) & !this.modinformation.get(modalityID).get("disease").contains(caseID)) {
                        this.modinformation.get(modalityID).get("disease").add(caseID);
                    }
                }
            }
            ++i;
        }
    }

    public void resetInputFile() {
        this.observerData = null;
        this.isLoaded = false;
        this.keyedData.clear();
        this.truthVals.clear();
        this.Nreader = 0L;
        this.Nnormal = 0L;
        this.Ndisease = 0L;
        this.Nmodality = 0L;
        this.resetIDs();
        this.filePathAndName = "";
        this.filePath = "";
        this.fileName = "";
        this.fileContent.clear();
        this.NlinesFileContent = 0;
        this.filePosition = 0;
        this.NrowsInHeader = 0;
        this.recordTitle = "Default Record Title";
        this.fileHeader = "Default Record Title,\nAll rows of input file before BEGIN DATA:";
        this.dataCheckResults = "";
    }

    public void resetIDs() {
        this.readerIDs.clear();
        this.caseIDs.clear();
        this.normalIDs.clear();
        this.diseaseIDs.clear();
        this.modalityIDs.clear();
    }
}

