\name{jester}
\alias{jester}
\alias{maxjest}
\alias{jokes}
\alias{humour}
\alias{humor}
\alias{jester_maxp}
\docType{data}
\title{Jester dataset}
\description{A likelihood function for the Jester datasets}
\usage{data(jester)}
\details{

Object \code{jester} is a likelihood function for the 91 jokes rated by
the first 150 respondents in file \file{jester_dataset_1_3.zip}, taken
from \url{https://eigentaste.berkeley.edu/dataset/}.  Object
\code{jester_maxp} is the result of running \code{maxp(jester)}.

Objects \code{jester} and \code{jester_maxp} can be generated by running
script \file{inst/jester.Rmd}, which includes some further technical
documentation.  This file takes about 10 minutes to run.

The dataset is interesting because it has been analysed by many workers,
including Goldberg, for patterns; here I assume that all the respondents
behave identically (but randomly).  It is included here because it is a
very severe numerical challenge in the context of the \code{hyper2}
package.  I am not convinced that \code{maxjest} is even close to the
true evaluate.

}
\references{
Eigentaste: A Constant Time Collaborative Filtering Algorithm.  Ken
Goldberg, Theresa Roeder, Dhruv Gupta, and Chris
Perkins. \emph{Information Retrieval}, 4(2), 133-151. July 2001.
}

\examples{

data(jester)
# maxp(jester)  # takes too long

loglik(indep(jester_maxp),jester)

}
\keyword{datasets}

