% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/case_anarbe.R
\name{collectData_csv_anarbe}
\alias{collectData_csv_anarbe}
\title{Collect data from csv for Anarbe case.}
\source{
http://meteo.navarra.es/estaciones/mapadeestaciones.cfm
}
\usage{
collectData_csv_anarbe(folderName, output = TRUE)
}
\arguments{
\item{folderName}{A string showing the path of the folder holding different csv files.}

\item{output}{A boolean showing whether the output is given, default is T.}
}
\value{
The collected data from different csv files.
}
\description{
Collect data from the gauging stations in spain, catchement Anarbe
}
\examples{
#use internal data as an example.
file <- system.file("extdata", "1999.csv", package = "hyfo")
folder <- strsplit(file, '1999')[[1]][1]
a <- collectData_csv_anarbe(folder)

# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}
\references{
\itemize{
\item http://meteo.navarra.es/estaciones/mapadeestaciones.cfm
\item R Core Team (2015). R: A language and environment for statistical computing. R Foundation for
Statistical Computing, Vienna, Austria. URL http://www.R-project.org/.
}
}

