% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AE.R
\name{routing}
\alias{routing}
\title{Estimate Models and Make Predictions}
\usage{
routing(
  real_AE,
  initials,
  relation,
  formula = y ~ x,
  model = stats::lm,
  FKM_MAX = 65,
  ...
)
}
\arguments{
\item{real_AE}{Data frame that contains real AEs of two neighboring hydrographs
estimated with \code{\link[=estimate_AE]{estimate_AE()}}.}

\item{initials}{Data frame that contains initial values for predictions
(see vignette).}

\item{relation}{Data frame that contains the relation between upstream and
downstream hydrograph. Must only contain two rows (one for each hydrograph)
in order of their location in downstream direction.
See the appended example data \code{relation.csv} or vignette for details on
the structure. See \code{\link[=get_lag]{get_lag()}} for further information
about the relation and the lag between the hydrographs.}

\item{formula}{An object of class \code{\link[stats:formula]{stats::formula()}}
to fit models.}

\item{model}{Function which specifies the method used for fitting models
(default: \code{\link[stats:lm]{stats::lm()}}). The model class must have a
\code{\link[stats:predict]{stats::predict()}} function.}

\item{FKM_MAX}{Numeric value that specifies the maximum fkm (see relation
file) for which predictions seem valid.}

\item{...}{Additional arguments to be passed to the function specified in
argument \code{model}.}
}
\value{
A nested list containing a grid of scatterplots (`gtable` object) for
    neighboring hydrographs with a regression line for each metric, a data
    frame of results of the model fitting where each row contains the
    corresponding stations and metric, the model type (default: "lm"), formula,
    coefficients, number of observations and \eqn{R^2}, and a plot of predicted
    values based on the \dQuote{initial values}.
}
\description{
Performs the \dQuote{routing} procedure, i.e., based on associated events,
    it uses (linear) models to describe translation and retention processes
    between neighboring hydrographs.
}
