% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_to_flowlines.R
\name{link_to_flowlines}
\alias{link_to_flowlines}
\title{Link geopoints to flowlines}
\usage{
link_to_flowlines(lats, lons, ids, max_dist = 100, dataset = c("nhdh",
  "nhdplusv2"))
}
\arguments{
\item{lats}{Vector of point latitudes}

\item{lons}{Vector of point longitudes}

\item{ids}{Vector of point identifiers (string or numeric)}

\item{max_dist}{numeric maximum line snapping distance in meters}

\item{dataset}{Character name of dataset to link against. Can be either "nhdh" or "nhdplusv2"}
}
\value{
flowline permanent ids
}
\description{
Link geopoints to flowlines in the NHD
}
\examples{
\dontrun{
latlon = c(42.703290, -73.702855)

#should link to hudson river
link_to_flowlines(latlon[1], latlon[2], 'dummyid')

}

}
