% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.hybridEnsemble.R
\name{importance.hybridEnsemble}
\alias{importance.hybridEnsemble}
\title{Importance method for hybridEnsemble objects}
\usage{
\method{importance}{hybridEnsemble}(
  x = NULL,
  xdata = NULL,
  ydata = NULL,
  method = "MEAN",
  CV = 1,
  sort = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class hybridEnsemble created by the function \code{hybridEnsemble}}

\item{xdata}{A test data frame with the same predictors as in the training data}

\item{ydata}{A test factor of observed class labels (responses) with the only allowed values \{0,1\}.}

\item{method}{One of 'RBGA' (Genetic Algorithm), 'DEOPT' (Differential Evolution), 'GENSA' (Generalized Simulated Annealing), 'MALSCHAINS' (Memetic Algorithm), 'PSOPTIM' (Particle Swarm), 'SOMA' (Self Organizing Migrating Algorithm), 'TABU' (Tabu Search), 'LHNNLS' (Lawson-Hanson Non-negative least squares), 'GINNLS' (Goldfarb-Idnani Non-negative least squares), 'NNloglik' (Non-negative binomial likelihood), 'MEAN' (Simple Mean), 'SB' (Single Best), 'AUTHORITY' (Authority Based method)}

\item{CV}{An integer indicating the number of cross-validation runs}

\item{sort}{TRUE or FALSE. Should the predictors be sorted with the most important ones on top?}

\item{...}{Not currently used}
}
\value{
A data frame with two colums: the variable name and the importance of the variable.
}
\description{
Assess the importance of new data using a hybridEnsemble model. The importance is computed as follows. For each variable, compute the AUC of the model before permuting that variable and after. Next, subtract the latter from the former. This is called the decrease in AUC. If CV is greater than one, the mean is taken from all runs.
}
\examples{

data(Credit)

\dontrun{
hE <-hybridEnsemble(x=Credit[1:100,names(Credit) != 'Response'],
                    y=Credit$Response[1:100],
                    RF.ntree=50,
                    AB.iter=50,
                    NN.size=5,
                    NN.decay=0,
                    SV.gamma = 2^-15,
                    SV.cost = 2^-5,
                    SV.degree=2,
                    SV.kernel='radial')
                    
 importance(hE,
          xdata=Credit[1:100,names(Credit) != 'Response'],
          ydata=Credit$Response[1:100])                   
}
                     

}
\references{
Ballings, M., Vercamer, D., Bogaert, M., Van den Poel, D.
}
\seealso{
\code{\link{hybridEnsemble}}, \code{\link{predict.hybridEnsemble}}, \code{\link{CVhybridEnsemble}}, \code{\link{plot.CVhybridEnsemble}}
}
\author{
Michel Ballings, Dauwe Vercamer, Matthias Bogaert, and Dirk Van den Poel, Maintainer: \email{Michel.Ballings@GMail.com}
}
