// Generated by rstantools.  Do not edit by hand.

/*
    hwep is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hwep is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hwep.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_gl_null_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_gl_null");
    reader.add_event(37, 35, "end", "model_gl_null");
    return reader;
}
#include <stan_meta_header.hpp>
class model_gl_null
  : public stan::model::model_base_crtp<model_gl_null> {
private:
        int N;
        int K;
        int khalf;
        matrix_d gl;
        vector_d alpha;
public:
    model_gl_null(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_gl_null(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_gl_null_namespace::model_gl_null";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 2);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "khalf", "int", context__.to_vec());
            khalf = int(0);
            vals_i__ = context__.vals_i("khalf");
            pos__ = 0;
            khalf = vals_i__[pos__++];
            check_greater_or_equal(function__, "khalf", khalf, 2);
            current_statement_begin__ = 5;
            validate_non_negative_index("gl", "N", N);
            validate_non_negative_index("gl", "(K + 1)", (K + 1));
            context__.validate_dims("data initialization", "gl", "matrix_d", context__.to_vec(N,(K + 1)));
            gl = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, (K + 1));
            vals_r__ = context__.vals_r("gl");
            pos__ = 0;
            size_t gl_j_2_max__ = (K + 1);
            size_t gl_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < gl_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < gl_j_1_max__; ++j_1__) {
                    gl(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("alpha", "khalf", khalf);
            context__.validate_dims("data initialization", "alpha", "vector_d", context__.to_vec(khalf));
            alpha = Eigen::Matrix<double, Eigen::Dynamic, 1>(khalf);
            vals_r__ = context__.vals_r("alpha");
            pos__ = 0;
            size_t alpha_j_1_max__ = khalf;
            for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
                alpha(j_1__) = vals_r__[pos__++];
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 10;
            validate_non_negative_index("p", "khalf", khalf);
            num_params_r__ += (khalf - 1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_gl_null() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 10;
        if (!(context__.contains_r("p")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        validate_non_negative_index("p", "khalf", khalf);
        context__.validate_dims("parameter initialization", "p", "vector_d", context__.to_vec(khalf));
        Eigen::Matrix<double, Eigen::Dynamic, 1> p(khalf);
        size_t p_j_1_max__ = khalf;
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            p(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.simplex_unconstrain(p);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 10;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> p;
            (void) p;  // dummy to suppress unused var warning
            if (jacobian__)
                p = in__.simplex_constrain(khalf, lp__);
            else
                p = in__.simplex_constrain(khalf);
            // transformed parameters
            current_statement_begin__ = 15;
            validate_non_negative_index("q", "(K + 1)", (K + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> q((K + 1));
            stan::math::initialize(q, DUMMY_VAR__);
            stan::math::fill(q, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 16;
            for (int k = 1; k <= (K + 1); ++k) {
                {
                current_statement_begin__ = 17;
                int iup(0);
                (void) iup;  // dummy to suppress unused var warning
                stan::math::fill(iup, std::numeric_limits<int>::min());
                stan::math::assign(iup,std::min((k - 1), (khalf - 1)));
                current_statement_begin__ = 18;
                int ilo(0);
                (void) ilo;  // dummy to suppress unused var warning
                stan::math::fill(ilo, std::numeric_limits<int>::min());
                stan::math::assign(ilo,std::max(0, (k - khalf)));
                current_statement_begin__ = 19;
                stan::model::assign(q, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            0.0, 
                            "assigning variable q");
                current_statement_begin__ = 20;
                for (int i = ilo; i <= iup; ++i) {
                    current_statement_begin__ = 21;
                    stan::model::assign(q, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                (stan::model::rvalue(q, stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), "q") + (get_base1(p, (i + 1), "p", 1) * get_base1(p, (k - i), "p", 1))), 
                                "assigning variable q");
                }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 15;
            size_t q_j_1_max__ = (K + 1);
            for (size_t j_1__ = 0; j_1__ < q_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(q(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: q" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable q: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            stan::math::check_simplex(function__, "q", q);
            // model body
            current_statement_begin__ = 27;
            lp_accum__.add(dirichlet_log(p, alpha));
            current_statement_begin__ = 28;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 29;
                validate_non_negative_index("lq", "(K + 1)", (K + 1));
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lq((K + 1));
                stan::math::initialize(lq, DUMMY_VAR__);
                stan::math::fill(lq, DUMMY_VAR__);
                current_statement_begin__ = 30;
                for (int j = 1; j <= (K + 1); ++j) {
                    current_statement_begin__ = 31;
                    stan::model::assign(lq, 
                                stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                (get_base1(gl, i, j, "gl", 1) + stan::math::log(get_base1(q, j, "q", 1))), 
                                "assigning variable lq");
                }
                current_statement_begin__ = 33;
                lp_accum__.add(log_sum_exp(lq));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("p");
        names__.push_back("q");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(khalf);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K + 1));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_gl_null_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> p = in__.simplex_constrain(khalf);
        size_t p_j_1_max__ = khalf;
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            vars__.push_back(p(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 15;
            validate_non_negative_index("q", "(K + 1)", (K + 1));
            Eigen::Matrix<double, Eigen::Dynamic, 1> q((K + 1));
            stan::math::initialize(q, DUMMY_VAR__);
            stan::math::fill(q, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 16;
            for (int k = 1; k <= (K + 1); ++k) {
                {
                current_statement_begin__ = 17;
                int iup(0);
                (void) iup;  // dummy to suppress unused var warning
                stan::math::fill(iup, std::numeric_limits<int>::min());
                stan::math::assign(iup,std::min((k - 1), (khalf - 1)));
                current_statement_begin__ = 18;
                int ilo(0);
                (void) ilo;  // dummy to suppress unused var warning
                stan::math::fill(ilo, std::numeric_limits<int>::min());
                stan::math::assign(ilo,std::max(0, (k - khalf)));
                current_statement_begin__ = 19;
                stan::model::assign(q, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            0.0, 
                            "assigning variable q");
                current_statement_begin__ = 20;
                for (int i = ilo; i <= iup; ++i) {
                    current_statement_begin__ = 21;
                    stan::model::assign(q, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                (stan::model::rvalue(q, stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), "q") + (get_base1(p, (i + 1), "p", 1) * get_base1(p, (k - i), "p", 1))), 
                                "assigning variable q");
                }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 15;
            stan::math::check_simplex(function__, "q", q);
            // write transformed parameters
            if (include_tparams__) {
                size_t q_j_1_max__ = (K + 1);
                for (size_t j_1__ = 0; j_1__ < q_j_1_max__; ++j_1__) {
                    vars__.push_back(q(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_gl_null";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t p_j_1_max__ = khalf;
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t q_j_1_max__ = (K + 1);
            for (size_t j_1__ = 0; j_1__ < q_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "q" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t p_j_1_max__ = (khalf - 1);
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t q_j_1_max__ = ((K + 1) - 1);
            for (size_t j_1__ = 0; j_1__ < q_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "q" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_gl_null_namespace::model_gl_null stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
