% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{lambda_1000}
\alias{lambda_1000}
\title{Normalize Lambda inflation factors to specific case-control count}
\usage{
lambda_1000(p.values, n = 1000, m = 1000)
}
\arguments{
\item{p.values}{numeric, a vector of analysis p.values, generated from n cases and m controls (although order switching n/m makes no difference to this function)}

\item{n}{integer, original number of cases that p.values were derived from}

\item{m}{integer, original number of controls that p.values were derived from}
}
\value{
A normalized Lambda coefficient
}
\description{
Lambda inflation statistics are influenced by the size of the generating datasets. To facilitate
comparison to other studies, this function calculates then converts a given lambda from 
n cases and m controls, to be equivalent to 1000 cases and 1000 controls.
}
\examples{
# create some p-values with clear 'inflation' (divergence from uniform[0,1])
p.vec <- c(runif(3000)/200,runif(7000)) 
# let's imagine these p values come from 3000 cases and 5000 controls
L1000_a <- lambda_1000(p.vec,3000,5000)
# alternatively, imagine the sample sizes are 10 times larger
L1000_b <- lambda_1000(p.vec,30000,50000)
plot(sort(p.vec),type="l") 
L1000_a; L1000_b
}
\references{
Freedman M.L., et al. Assessing the impact of population stratification
 on genetic association studies. Nat. Genet. 2004;36:388-393.
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
