% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\docType{class}
\name{ChipInfo-class}
\alias{ChipInfo-class}
\alias{ChipInfo-method}
\alias{initialize,ChipInfo-method}
\title{Class to represent SNP annotation for a microarray}
\usage{
\S4method{initialize}{ChipInfo}(.Object, ...)
}
\arguments{
\item{.Object}{An object generated from the ChipInfo class prototype,
see methods:initialize}

\item{...}{Additional arguments to initialize. None recommended.}
}
\description{
This class annotates a microarray SNP chip with data for each SNP including chromosome,
id, position, strand, 'rs' id, allele 1, allele 2 for each SNP of a microarray chip,
in either hg18, hg19 or hg38 (build 36/37/38) coordinates.
This package makes extension use of this class of annotation object for the working
microarray chip, e.g, default is ImmunoChip, 
and you can also load your own annotation if using a different chip. The class
is basically a GRanges object, modified to always have columns for A1, A2 (alleles), 
rs.id, and a quality control flag. The default display is tidier than GRanges, it has
nice coersion to and frame data.frame and subsetting by chromosome using [[n]] has been
added, in addition to normal [i,j] indexing native to GRanges.
Note that with this package the first time annotation is used it might be slow, but
subsequent calls should be fast.
METHODS
 "[[", show, print, length, dim, rownames, initialize
 build, chip, rs.id, A1, A2, QCcode, QCcode<-, QCpass, QCfail
 convTo36, convTo37, convTo38
COERCION
 can use 'as' to convert to and from: GRanges, RangedData, data.frame

Use the 'ChipInfo()' wrapper to construct ChipInfo objects from scratch
}
\section{Fields}{
 
 \describe{
   \item{\code{seqnames}:}{Object of class \code{"Rle"}, containing chromosomes for each range, see GRanges.}
   \item{\code{ranges}:}{Object of class \code{"IRanges"}, containing genomic start and end, see GRanges.}
   \item{\code{strand}:}{Object of class \code{"Rle"}, containing plus or minus coding for forward or reverse strand, see GRanges.}
   \item{\code{seqinfo}:}{Object of class \code{"Seqinfo"}, containing chromosome listing, see GRanges.}
   \item{\code{chip}:}{Name, class \code{"character"}, containing user description of the chip, e.g, 'immunoChip'.}
   \item{\code{build}:}{Object of class \code{"character"}, annotation version, e.g, hg18, hg19, hg38, etc.}
   \item{\code{elementMetaData}:}{Object of class \code{"DataFrame"}, see GRanges, but with specific column names:
 A1, A2, QCcode and rs.id.}
 }
}
\author{
Nick Cooper
}

