% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-mock-url.R
\name{build_mock_url}
\alias{build_mock_url}
\title{Convert a request to a mock file path}
\usage{
build_mock_url(req)
}
\arguments{
\item{req}{A \code{httr2_request} object}
}
\value{
A file path and name, without an extension. The file, or a file with
some extension appended, may or may not
exist: existence is not a concern of this function.
}
\description{
Requests are translated to mock file paths according to several rules that
incorporate the request method, URL, query parameters, and body.
}
\details{
First, the request protocol, such as "https://", is removed from the URL.
Second, if the request URL contains a query string, it will be popped off,
hashed by \code{\link[digest:digest]{digest::digest()}}, and the first six characters appended to the
file being read. Third, request bodies are similarly hashed and
appended. Finally, if a request method other than GET is used it will be
appended to the end of the end of the file name.

Mock file paths also have a file extension appended, based on the
\code{Content-Type} of the response, though this function, which is only concerned
with the request, does not add the extension. In an
HTTP API, a "directory" itself is a resource,
so the extension allows distinguishing directories and files in the file
system. That is, a mocked \verb{GET http://example.com/api/} may read a
"example.com/api.json" file, while
\verb{GET http://example.com/api/object1/} reads "example.com/api/object1.json".

Other examples:
\itemize{
\item \verb{GET http://example.com/api/object1/?a=1} may read
"example.com/api/object1-b64371.xml".
\item \verb{POST http://example.com/api/object1/?a=1} may read
"example.com/api/object1-b64371-POST.json".
}

Note that if you are trying to guess the mock file paths corresponding to a
test for which you intend to create a mock file manually,
instead of trying to build the URL, you should run the test
with \code{with_mock_api()} as the error message will contain the mock file path.
}
\seealso{
\code{\link[=with_mock_api]{with_mock_api()}} \code{\link[=capture_requests]{capture_requests()}}
}
\keyword{internal}
