% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_exp_hts.R
\name{d_exp_hts}
\alias{d_exp_hts}
\title{Extraction of a time-series from htsr data base}
\usage{
d_exp_hts(fsq, sta, sen, rtime = FALSE, dstart, dend, rplot = FALSE)
}
\arguments{
\item{fsq}{Full name of the data base}

\item{sta}{Station id.}

\item{sen}{Sensor id.}

\item{rtime}{Reduce time interval TRUE / FALSE (default)}

\item{dstart}{Start date YYYY-MM-DD (default: start date of the ts)}

\item{dend}{End date YYYY-MM-DD (default: end date of the ts)}

\item{rplot}{Plot the extracted file TRUE / FALSE (default)}
}
\value{
The function returns:
\itemize{
\item a tibble tstab with 4 columns Date, Value, Station, Sensor
\item a file (nomfic) with the following name:
<sensor.id>_<station.id>.hts}
}
\description{
The function extracts a time-series in the "hts" format. It products a "tibble"
table with four columns : Date, Value, Station, Sensor. It is the default format of the package.
The function \code{\link{f_convert}} converts it in Excel or csv format.
}
\details{
For a step by step operation the function \code{\link{ds_exp_hts}} is more convenient.
}
\examples{
\dontrun{

f <- d_exp_hts("foo.sqlite","M","station","sensor")


}

}
\seealso{
\code{\link{ds_exp_hts}} manual settings of the parameters
}
\author{
P. Chevallier - oct 2017 - dec 2019
}
