% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.hpiaccuracy}
\alias{plot.hpiaccuracy}
\title{Plot method for `hpiaccuracy` object}
\usage{
\method{plot}{hpiaccuracy}(x, return_plot = FALSE, do_plot = TRUE,
  use_log_error = FALSE, ...)
}
\arguments{
\item{x}{Object to plot of class `hpiaccuracy``}

\item{return_plot}{default = FALSE; Return the plot to the function call}

\item{do_plot}{default = FALSE; Execute plotting to terminal/console}

\item{use_log_error}{[FALSE] Use the log error?}

\item{...}{Additional Arguments}
}
\value{
`plotaccuracy` object inheriting from a ggplot object
}
\description{
Specific plotting method for hpiaccuracy objects
}
\examples{

 # Load Data
 data(ex_sales)

 # Create Index
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Calculate insample accuracy
 hpi_accr <- calcAccuracy(hpi_obj = rt_index,
                          test_type = 'rt',
                          test_method = 'insample')

 # Make Plot
 plot(hpi_accr)

}
