% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kp_historical_tables.R
\name{kp_conf}
\alias{kp_conf}
\title{\strong{Get KenPom's conference-wide stats}}
\usage{
kp_conf(year, conf)
}
\arguments{
\item{year}{Year (YYYY)}

\item{conf}{Used to limit to players in a specific conference. Allowed values are: 'A10', 'ACC', 'AE', 'AMER', \cr
'ASUN', 'B10', 'B12', 'BE', 'BSKY', 'BSTH', 'BW', 'CAA', 'CUSA', 'HORZ', 'IND', IVY', \cr
'MAAC', 'MAC', 'MEAC', 'MVC', 'MWC', 'NEC', 'OVC', 'P12', 'PAT', 'SB', 'SC', 'SEC', 'SLND', \cr
'SUM', 'SWAC', 'WAC', 'WCC'. \cr
If you try to use a conference that doesn't exist for a given season, like 'IND' and '2018', \cr
you'll get an empty table, as kenpom.com doesn't serve 404 pages for invalid table queries like that.\cr
No filter applied by default.}
}
\value{
A list of 7 dataframes accessible via \code{[[1]]},\code{[[2]]},...,,\code{[[7]]}\cr
First data frame, accessible via \code{[[1]]}\cr
A data frame with 15 columns:
\describe{
\item{\code{Team}}{character.}
\item{\code{Overall}}{character.}
\item{\code{Conf}}{character.}
\item{\code{AdjEM}}{double.}
\item{\code{AdjEM.Rk}}{double.}
\item{\code{AdjO}}{double.}
\item{\code{AdjO.Rk}}{double.}
\item{\code{AdjD}}{double.}
\item{\code{AdjD.Rk}}{double.}
\item{\code{AdjT}}{double.}
\item{\code{AdjT.Rk}}{double.}
\item{\code{ConfSOS}}{double.}
\item{\code{ConfSOS.Rk}}{double.}
\item{\code{NextGame}}{character.}
\item{\code{Year}}{character.}
}
Second data frame, accessible via \code{[[2]]}\cr
A data frame with 20 columns:
\describe{
\item{\code{Team}}{character.}
\item{\code{OE}}{double.}
\item{\code{OE.Rk}}{double.}
\item{\code{eFG.Pct}}{double.}
\item{\code{eFG.Pct.Rk}}{double.}
\item{\code{TO.Pct}}{double.}
\item{\code{TO.Pct.Rk}}{double.}
\item{\code{OR.Pct}}{double.}
\item{\code{OR.Pct.Rk}}{double.}
\item{\code{FTR}}{double.}
\item{\code{FTR.Rk}}{double.}
\item{\code{FG2.Pct}}{double.}
\item{\code{FG2.Pct.Rk}}{double.}
\item{\code{FG3.Pct}}{double.}
\item{\code{FG3.Pct.Rk}}{double.}
\item{\code{FT.Pct}}{double.}
\item{\code{FT.Pct.Rk}}{double.}
\item{\code{Tempo}}{double.}
\item{\code{Tempo.Rk}}{double.}
\item{\code{Year}}{character.}
}
Third data frame, accessible via \code{[[3]]}\cr
A data frame with 20 columns:
\describe{
\item{\code{Team}}{character.}
\item{\code{DE}}{double.}
\item{\code{DE.Rk}}{double.}
\item{\code{eFG.Pct}}{double.}
\item{\code{eFG.Pct.Rk}}{double.}
\item{\code{TO.Pct}}{double.}
\item{\code{TO.Pct.Rk}}{double.}
\item{\code{OR.Pct}}{double.}
\item{\code{OR.Pct.Rk}}{double.}
\item{\code{FTR}}{double.}
\item{\code{FTR.Rk}}{double.}
\item{\code{FG2.Pct}}{double.}
\item{\code{FG2.Pct.Rk}}{double.}
\item{\code{FG3.Pct}}{double.}
\item{\code{FG3.Pct.Rk}}{double.}
\item{\code{Blk.Pct}}{double.}
\item{\code{Blk.Pct.Rk}}{double.}
\item{\code{Stl.Pct}}{double.}
\item{\code{Stl.Pct.Rk}}{double.}
\item{\code{Year}}{character.}
}
Fourth data frame, accessible via \code{[[4]]}\cr
A data frame with 3 columns:
\describe{
\item{\code{Rk}}{integer.}
\item{\code{Player}}{character.}
\item{\code{Year}}{character.}
}
Fifth data frame, accessible via \code{[[5]]}\cr
A data frame with 4 columns:
\describe{
\item{\code{Stat}}{character.}
\item{\code{Value}}{double.}
\item{\code{Rk}}{double.}
\item{\code{Year}}{character.}
}
Sixth data frame, accessible via \code{[[6]]}\cr
A data frame with 5 columns:
\describe{
\item{\code{Stat}}{character.}
\item{\code{Count}}{character.}
\item{\code{Value}}{double.}
\item{\code{Rk}}{double.}
\item{\code{Year}}{character.}
}
Seventh data frame, accessible via \code{[[7]]}\cr
A data frame 4 columns:
\describe{
\item{\code{Rk}}{double.}
\item{\code{Conference}}{character.}
\item{\code{Rating}}{double.}
\item{\code{Year}}{character.}
}
}
\description{
\strong{Get KenPom's conference-wide stats}
}
\examples{
\donttest{
    try(kp_conf(year = 2020, conf = 'ACC'))
}
}
\keyword{Conference}
\keyword{Stats}
