% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_individual.R
\name{calculate_individual}
\alias{calculate_individual}
\title{Calculate individual player stats}
\usage{
calculate_individual(pbp, type = c("R", "P"), game_strength = "all")
}
\arguments{
\item{pbp}{A tibble of play-by-play data, typically returned from either
\code{\link{load_pbp}} or \code{\link{scrape_game}}}

\item{type}{Season type to filter by; "R" for regular season and/or "P" for postseason}

\item{game_strength}{String or vector of strings defining strength state to
filter by; ex c("3v5","4v5","3v4") returns stats for shorthanded strength}
}
\value{
A tibble containing individual shooting stats for all players in supplied pbp data.
\strong{These stats are individual player stats, not player on-ice stats.}
For help with on-ice stats, please see \code{\link{calculate_on_ice}}.
\describe{
\item{player_name}{String identifying player name}
\item{player_id}{Integer value of the NHL player ID}
\item{team}{String identifying player's most recent team}
\item{gp}{Games Played}
\item{ixg}{Numeric expected goals}
\item{goals}{Numeric goals scored}
\item{assists}{Numeric total assists}
\item{points}{Numeric points scored}
\item{assists_primary}{Numeric primary assists}
\item{assists_secondary}{Numeric secondary assists}
\item{points_primary}{Numeric primary points}m
\item{gax}{Numeric goals scored over expected}
\item{icf}{Numeric shot attempts (Corsi)}
\item{iff}{Numeric unblocked shot attempts (Fenwick)}
\item{isog}{Numeric shots on goal}
\item{sh_perc}{Numeric shooting percentage}
}
If supplied play-by-play data includes shift change events (the default for \code{\link{scrape_game}};
if using \code{\link{load_pbp}} user must set \code{shift_events} argument to \code{TRUE}) then
the following rate stats will also be calculated:
\describe{
\item{toi}{String description of total time on ice in 'minutes:seconds'}
\item{mean_toi}{String description of average time on ice over all supplied games, in 'minutes:seconds'}
\item{toi_minutes}{Numeric total time on ice, in minutes}
\item{mean_toi_minutes}{Numeric average time on ice over all supplied games, in minutes}
\item{ixg_per60}{Numeric expected goals per 60 minutes}
\item{goals_per60}{Numeric goals scored per 60 minutes}
\item{assists_per60}{Numeric total assists per 60 minutes}
\item{points_per60}{Numeric points scored per 60 minutes}
\item{assists_primary_per60}{Numeric primary assists per 60 minutes}
\item{assists_secondary_per60}{Numeric secondary assists per 60 minutes}
\item{points_primary_per60}{Numeric primary points per 60 minutes}
\item{gax_per60}{Numeric goals scored over expected per 60 minutes}
\item{icf_per60}{Numeric shot attempts (Corsi) per 60 minutes}
\item{iff_per60}{Numeric unblocked shot attempts (Fenwick) per 60 minutes}
\item{isog_per60}{Numeric shots on goal per 60 minutes}
}
}
\description{
Calculate individual player stats
}
\examples{
\dontrun{
#load pbp
pbp_2022 <- load_pbp(2022, shift_events = TRUE)
player_stats <- calculate_individual(pbp_2022, type = "R", game_strength = "5v5")
}
}
