% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_imp_roundedcont_2018-02-23.R
\name{imp_roundedcont}
\alias{imp_roundedcont}
\title{The function to impute rounded continuous variables}
\usage{
imp_roundedcont(y_df, X, PSI, pvalue = 0.2, rounding_degrees = NULL)
}
\arguments{
\item{y_df}{A data.frame with the variable to impute.}

\item{X}{A data.frame with the fixed effects variables.}

\item{PSI}{A data.frame with the variables explaining the latent rounding tendency G.}

\item{pvalue}{A numeric between 0 and 1 denoting the threshold of p-values a variable in the imputation
model should not exceed. If they do, they are excluded from the imputation model.}

\item{rounding_degrees}{A numeric vector with the presumed rounding degrees.
Or a list with model formulas for G, where each list element has the name of a rounded continuous variable.
Such a list can be generated}
}
\value{
A n x 1 data.frame with the original and imputed values.
}
\description{
For example the income in surveys is often reported rounded by the respondents.
See Drechsler, Kiesl and Speidel (2015) for more details.
}
\references{
Joerg Drechsler, Hans Kiesl, Matthias Speidel (2015):
"MI Double Feature: Multiple Imputation to Address Nonresponse and Rounding Errors in Income Questions".
Austrian Journal of Statistics Vol. 44, No. 2, http://dx.doi.org/10.17713/ajs.v44i2.77
}
