% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele-mism-freq.R
\name{CalAlleleMismFreq}
\alias{CalAlleleMismFreq}
\title{Evaluate the frequency of specific allele mismatches}
\usage{
CalAlleleMismFreq(dat_in, nms_don = c(), nms_rcpt = c())
}
\arguments{
\item{dat_in}{A data frame of clean HLA typing data.}

\item{nms_don}{A vector of column names of donor's alleles, must be length of 2.}

\item{nms_rcpt}{A vector of column names of recipient's alleles, must be length of 2.}
}
\value{
A data frame of donor's mismatched alleles with frequency > 1. No mismatch is calculated if input alleles are NA.
}
\description{
This function evaluates allele level mismatch between donor and recipient and then presents the most commonly mismatched alleles. This function is most effectively used to study the most common mismatches within a transplant population.
}
\examples{
dat <- read.csv(system.file("extdata/example", "HLA_MisMatch_test.csv", package = "hlaR"))
don <- c("donor.a1", "donor.a2")
rcpt <- c("recipient.a1", "recipient.a2")
re <- CalAlleleMismFreq(dat_in = dat, nms_don = don, nms_rcpt = rcpt)
}
