% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbl_plot_tau.R
\name{hbl_plot_tau}
\alias{hbl_plot_tau}
\title{Plot tau}
\usage{
hbl_plot_tau(mcmc)
}
\arguments{
\item{mcmc}{Data frame of posterior samples generated by
\code{\link[=hbl_mcmc_hierarchical]{hbl_mcmc_hierarchical()}}.}
}
\value{
A \code{ggplot} object
}
\description{
Plot the rep-specific tau parameters
of a fitted hierarchical model.
}
\examples{
if (!identical(Sys.getenv("HBL_TEST", unset = ""), "")) {
set.seed(0)
data <- hbl_sim_independent(n_continuous = 2)$data
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc <- hbl_mcmc_hierarchical(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
hbl_plot_tau(mcmc)
}
}
\seealso{
Other plot: 
\code{\link{hbl_plot_borrow}()},
\code{\link{hbl_plot_group}()}
}
\concept{plot}
