% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{rmLargeSpread}
\alias{rmLargeSpread}
\title{Delete entries for which the spread is more than \code{maxi} times the median spread}
\usage{
rmLargeSpread(qData, maxi = 50, tz = NULL)
}
\arguments{
\item{qData}{an \code{xts} or \code{data.table} object at least containing the columns \code{"BID"} and \code{"OFR"}.}

\item{maxi}{an integer. By default \code{maxi = "50"}, which means that entries are deleted 
if the spread is more than 50 times the median spread on that day.}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. With the non-disk functionality, we attempt to extract the timezone from the DT column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}. 
In the on-disk functionality, if tz is not specified, the timezone used will be the system default.}
}
\value{
\code{xts} or \code{data.table} object depending on input.
}
\description{
Function deletes entries for which the spread is more than \code{"maxi"} times the median
spread on that day.
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{cleaning}
