% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{mergeQuotesSameTimestamp}
\alias{mergeQuotesSameTimestamp}
\title{Merge multiple quote entries with the same time stamp}
\usage{
mergeQuotesSameTimestamp(qData, selection = "median")
}
\arguments{
\item{qData}{an \code{xts} object or \code{data.table} containing the time series data, with 
at least two columns named \code{BID} and \code{OFR} indicating the bid and ask price 
as well as two columns \code{BIDSIZ}, \code{OFRSIZ} indicating the number of round lots available at these 
prices. For \code{data.table} an additional column \code{DT} is necessary that stores the date/time information.}

\item{selection}{indicates how the bid and ask price for a certain time stamp
should be calculated in case of multiple observation for a certain time
stamp. By default, \code{selection = "median"}, and the median price is taken. Alternatively:
\itemize{
\item \code{selection = "max.volume"}: use the (bid/ask) price of the entry with
largest (bid/ask) volume.
\item \code{selection = "weighted.average"}: take the weighted average of all bid (ask) prices,
weighted by "BIDSIZ" ("OFRSIZ").
}}
}
\value{
Depending on the input data type, we return either a \code{data.table} or an \code{xts} object containing the quote data which has been cleaned.
}
\description{
Merge quote entries that have the same time stamp to a single one and returns an \code{xts} or a \code{data.table} object
 with unique time stamps only.
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{cleaning}
