% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{hc_exporting}
\alias{hc_exporting}
\title{Exporting options for higcharts objects}
\usage{
hc_exporting(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{http://api.highcharts.com/highcharts#exporting}.}
}
\description{
Exporting options for higcharts objects. You can define the file's name
or the output format.
}
\examples{

require("dplyr")

data("citytemp")

highchart() \%>\% 
  hc_xAxis(categories = citytemp$month) \%>\% 
  hc_add_serie(name = "Tokyo", data = citytemp$tokyo) \%>\% 
  hc_add_serie(name = "London", data = citytemp$london) \%>\% 
  hc_exporting(enabled = TRUE,
               filename = "custom-file-name")

}

