% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratum.R
\docType{methods}
\name{stratum}
\alias{stratum}
\alias{stratum,sts-method}
\title{Extract Strata}
\usage{
stratum(x, ...)

\S4method{stratum}{sts}(x, which = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{"sts"}.}

\item{...}{further arguments passed to methods.}

\item{which}{an integer (strata dimension) or \code{NULL} (to get the plain
\code{colnames}, the default).}
}
\value{
a character vector of strata names of length \code{ncol(x)}.
}
\description{
Methods to extract strata information from an object.
Here we only define a method for class \code{"sts"}.
}
\section{Methods (by class)}{
\itemize{
\item \code{sts}: Extract the names of the units, i.e., the \code{colnames},
from a multivariate \code{"sts"} object.
If the units result from the interaction of multiple strata
separated by dots, e.g., \code{"region.group"},
the function can also extract the names corresponding to a specific
strata dimension, e.g., \code{which = 2} to get the group names.
}}

\examples{
noroBEall <- noroBE(by = "all", flatten = TRUE)
stratum(noroBEall)  # just colnames(noroBEall)
stratum(noroBEall, which = 2)  # the age groups
}
