% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{cum_prob}
\alias{cum_prob}
\title{Estimates the cumulative probability for a vector of x values}
\usage{
cum_prob(this, x, clipped)
}
\arguments{
\item{this}{A hermite_estimator object.}

\item{x}{A numeric vector. Values at which to estimate the cumulative
probability}

\item{clipped}{A boolean value. This value determines whether cumulative
probabilities are clipped to lie within the range [0,1].}
}
\value{
A numeric vector of cumulative probability values.
}
\description{
This method calculates the cumulative probability values at a vector of
x values using the hermite_estimator object (this).
}
\details{
The object must be updated with observations prior to the use of this method.
}
\examples{
hermite_est <- hermite_estimator(N = 10, standardize = TRUE)
hermite_est <- update_batch(hermite_est, rnorm(30))
cdf_est <- cum_prob(hermite_est, c(0, 0.5, 1))
}
