\name{simulate.hergm}

\alias{simulate.hergm}

\alias{hergm.simulate}

\alias{simulate}

\title{Simulate network}

\description{

The function \code{simulate.hergm} accepts an object of class \code{hergm} as argument and simulates networks.

}

\usage{

\method{simulate}{hergm}(object, 
                         nsim = 1,
                         seed = NULL,
                         max_number = NULL,
                         indicator = NULL,
                         eta = NULL,
                         sample_size = 1,
                         verbose = 0,
                         \dots)
}

\arguments{

\item{object}{either object of class \code{hergm} or formula of the form \code{network ~ terms}; objects of class \code{hergm} can be generated by function \code{hergm}; \code{network} is an object of class \code{network} and can be created by calling the function \code{network}; possible terms can be found in \code{ergm.terms} and \code{hergm.terms}.}

\item{nsim}{redundant, but ensures that the \code{simulate} method is compatible with the \code{simulate} method of \code{R} package \code{stats}.}

\item{seed}{redundant, but ensures that the \code{simulate} method is compatible with the \code{simulate} method of \code{R} package \code{stats}.}

\item{max_number}{maximum number of blocks.}

\item{indicator}{indicators of block memberships of nodes.}

\item{eta}{\code{ergm.terms} and \code{hergm.terms} parameters.}

\item{sample_size}{number of networks to be simulated.}

\item{verbose}{if \code{verbose == -1}, no console output; if \code{verbose == 0}, short console output; if \code{verbose == +1}, long console output.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

The function \code{simulate.hergm} returns the simulated networks in the form of edge lists.

}

\seealso{hergm, ergm.terms, hergm.terms, gof.hergm}

\references{

Schweinberger, M. and P. Luna (2018). HERGM: Hierarchical exponential-family random graph models. Journal of Statistical Software, 85, 1--39.

}

\examples{
\dontrun{set.seed(123456789)

# Simulate 100 networks from model:
d <- matrix(rbinom(n=45*45, size=1, prob=.1), 45, 45)
d <- as.network(d, directed=TRUE, loops = FALSE)
N <- 100
indicator <- c(rep.int(1, 10), rep.int(2, 15), rep.int(3, 20))
eta <- c(-1.5, -2, -2.5, -4, .5, .5, .5, 0)
edgelists <- simulate.hergm(d ~ edges_ij + transitiveties_ijk,
    max_number=3, indicator=indicator, eta=eta, sample_size=N)
d <- lapply(as.network, X=edgelists$edgelist)
coord <- plot(d[[1]], vertex.col=indicator, edge.col=same_clusters(indicator))
for (i in 1:N) plot(d[[i]], vertex.col=indicator, edge.col=same_clusters(indicator), coord=coord)

# Estimate model from first simulated network:
network <- d[[1]]
object <- hergm(network ~ edges_ij + transitiveties_ijk, max_number=3)
# Plot network with estimated block structure:
plot(object)
}
}

