\name{print.hergm}

\alias{print.hergm}

\alias{hergm.print}

\title{Print summary of object of class \code{hergm}}

\description{

The function \code{print.hergm} accepts an object of class \code{hergm} as argument and prints a summary of parameters from the posterior.
Please note that the function \code{hergm} should have been called with \code{relabel > 0} to solve the so-called label-switching problem, 
which is done by default.
If the function \code{hergm} has not been called with option \code{relabel > 0},
call the function \code{hergm.postprocess} with \code{relabel > 0}.

}

\usage{

\method{print}{hergm}(x, \dots)

}

\arguments{

\item{x}{object of class \code{hergm}; objects of class \code{hergm} can be generated by function \code{hergm}.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\seealso{hergm, hergm.postprocess, plot.hergm, summary.hergm}

\references{

Schweinberger, M. and P. Luna (2018). HERGM: Hierarchical exponential-family random graph models. Journal of Statistical Software, 85, 1--39.

}

\examples{
\dontrun{data(example)
object <- hergm(d ~ edges_ij + triangle_ijk)
print(object)
}
}

