\name{plot.hergm}

\alias{plot.hergm}

\alias{hergm.plot}

\alias{plot}

\title{Plot summary of object of class \code{hergm}}

\description{

The function \code{plot.hergm} accepts an \code{object} of class \code{hergm} as argument and plots a summary of a sample of block memberships of nodes from the posterior.
Please note that the function \code{hergm} should have been called with \code{relabel > 0} to solve the so-called label-switching problem,
which is done by default. 
If the function \code{hergm} has not been called with option \code{relabel > 0},
call the function \code{hergm.postprocess} with \code{relabel > 0}.

}

\usage{

\method{plot}{hergm}(x, threshold = c(.7, .8, .9), \dots)

}

\arguments{

\item{x}{object of class \code{hergm}; objects of class \code{hergm} can be generated by function \code{hergm}.}

\item{threshold}{if the component \code{relabel} of the object of class \code{hergm} is \code{relabel = 3}, then threshold is a vector of thresholds between 0 and 1, indicating the thresholds at which the same-block-membership posterior probabilities of nodes are to be thresholded to construct the same-block graphs.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\seealso{hergm, hergm.postprocess, print.hergm, summary.hergm}

\references{

Schweinberger, M. and P. Luna (2018). HERGM: Hierarchical exponential-family random graph models. Journal of Statistical Software, 85, 1--39.

}

\examples{
\dontrun{data(example)
object <- hergm(d ~ edges_ij + triangle_ijk)
plot(object)
}
}

