% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hellmer-core.R
\name{process_future}
\alias{process_future}
\title{Process prompts in parallel chunks with error handling and state management}
\usage{
process_future(
  chat_obj,
  prompts,
  type_spec = NULL,
  state_path = tempfile("chat_", fileext = ".rds"),
  workers = parallel::detectCores(),
  chunk_size = NULL,
  plan = "multisession",
  max_chunk_attempts = 3L,
  max_retries = 3L,
  initial_delay = 1,
  max_delay = 60,
  backoff_factor = 2,
  timeout = 60,
  beep = TRUE
)
}
\arguments{
\item{chat_obj}{Chat model object for API calls}

\item{prompts}{Vector or list of prompts to process}

\item{type_spec}{Optional type specification for structured data extraction}

\item{state_path}{Path to save intermediate state}

\item{workers}{Number of parallel workers (default: number of CPU cores)}

\item{chunk_size}{Number of prompts to process in parallel at a time (default: 10\% of the number of prompts)}

\item{plan}{Parallel backend: "multisession" or "multicore"}

\item{max_chunk_attempts}{Maximum retries per failed chunk (default: 3)}

\item{max_retries}{Maximum retries per prompt (default: 3)}

\item{initial_delay}{Initial delay before first retry (default: 1)}

\item{max_delay}{Maximum delay between retries (default: 32)}

\item{backoff_factor}{Delay multiplier after each retry (default: 2)}

\item{timeout}{Maximum seconds per prompt (default: 60)}

\item{beep}{Play sound on completion/error (default: TRUE)}
}
\value{
Batch results object containing processed responses
}
\description{
Process prompts in parallel chunks with error handling and state management
}
\keyword{internal}
